% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_citation_network.R
\name{create_citation_network}
\alias{create_citation_network}
\title{Create Citation Co-occurrence Network}
\usage{
create_citation_network(
  citation_analysis_results,
  max_distance = 1000,
  min_connections = 1,
  show_labels = TRUE
)
}
\arguments{
\item{citation_analysis_results}{A list object returned by citation analysis functions,
containing at least two elements:
\itemize{
\item \code{network_data}: A data frame with columns \code{citation1}, \code{citation2},
and \code{distance} representing pairs of co-occurring citations
\item \code{citations}: A data frame with columns \code{citation_text_clean} and
\code{section} containing citation text and section information
\item \code{section_colors}: A named vector of colors for each section
}}

\item{max_distance}{Numeric. Maximum distance (in characters) between citations to be
considered connected. Default is 1000.}

\item{min_connections}{Integer. Minimum number of connections a citation must have to be
included in the network. Default is 1.}

\item{show_labels}{Logical. Whether to show citation labels on the network nodes.
Default is TRUE.}
}
\value{
A \code{visNetwork} object representing the interactive citation network, or NULL
if no valid network can be created. The returned object has an additional \code{stats}
attribute containing:
\itemize{
\item \code{n_nodes}: Number of nodes in the network
\item \code{n_edges}: Number of edges in the network
\item \code{avg_distance}: Average distance between connected citations
\item \code{max_distance}: Maximum distance parameter used
\item \code{section_distribution}: Distribution of citations across sections
\item \code{multi_section_citations}: Citations appearing in multiple sections
\item \code{section_colors}: Color mapping for sections
}
}
\description{
Creates an interactive network visualization of citation co-occurrences within a document.
Citations that appear close to each other are connected, with the strength of the connection
based on their distance (in characters). Nodes are colored by the document section where
citations primarily appear.
}
\details{
The function creates a network where:
\itemize{
\item \strong{Nodes} represent unique citations
\item \strong{Node size} is proportional to the number of connections
\item \strong{Node color} indicates the primary section where the citation appears
\item \strong{Node border} is thicker (3px) for citations appearing in multiple sections
\item \strong{Edges} connect citations that co-occur within the specified distance
\item \strong{Edge width} decreases with distance (closer citations = thicker edges)
\item \strong{Edge color} indicates distance: red (<=300 chars), blue (<=600 chars),
gray (>600 chars)
}

The network uses the Fruchterman-Reingold layout algorithm for optimal node positioning.
Interactive features include zooming, panning, node dragging, and highlighting of
nearest neighbors on hover.
}
\examples{
\dontrun{
# Assuming you have citation_analysis_results from a previous analysis
network <- create_citation_network(
  citation_analysis_results,
  max_distance = 800,
  min_connections = 2,
  show_labels = TRUE
)

# Display the network
network

# Access network statistics
stats <- attr(network, "stats")
print(stats$n_nodes)
print(stats$section_distribution)
}

}
