% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medians.R
\name{median.complex}
\alias{median.complex}
\title{Improved Median for Complex Numbers}
\usage{
\method{median}{complex}(x, na.rm = FALSE, tol = 1e-07, maxiter = 200, ...)
}
\arguments{
\item{x}{a numeric or complex vector, of which the median is to be calculated.}

\item{na.rm}{logical. Should NA values be removed before finding the median?}

\item{tol}{numeric. Relative tolerance to be passed to \link[pracma:geo_median]{pracma::geo_median}. Default is 1e-07.}

\item{maxiter}{maximum number of iterations for calculating geometric median. Not used if x is numeric.}

\item{...}{Additional arguments. Currently ignored.}
}
\value{
The median of x. If x is complex, the geometric median as calculated by Weiszfeld's algorithm.
}
\description{
By default \link[stats:median]{stats::median} handles complex numbers by computing the medians of the real and imaginary components separately.
This is not ideal as the result is not rotationally invariant (the same set of numbers will have a different median if the coordinates are rotated).
This method calculates the complex median as the geometric median, as implemented in \link[pracma:geo_median]{pracma::geo_median}, which is rotationally invariant.
}
\details{
The geometric median fails if any of the input data are colinear. Meaning that a straight line on the complex plane
can be drawn which intersects with one or more element of \code{x}. If this function encounters such an error, it adds a small
amount of random jitter to the data, then calculates the geometric medium again. The jitter is generated by a normal distribution
with a standard deviation equal to the absolute minimum real or imaginary component of \code{x}, divided by \eqn{10^8} (or 10^-9 if the minimum is zero).
}
\note{
This method masks the default method for complex numbers.
}
\examples{
set.seed(4242)
n <- 7
foo <- complex(real = rnorm(n), imaginary = rnorm(n))
median(foo)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth & Brooks/Cole.
}
\seealso{
\link[stats:median]{stats::median} and \link[pracma:geo_median]{pracma::geo_median}
}
