% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_outlier.r
\name{mad_outlier}
\alias{mad_outlier}
\title{Mark possible outliers with MAD.}
\usage{
mad_outlier(x, constant = 1.4826 * 3)
}
\arguments{
\item{x}{A numeric vector.}

\item{constant}{The constant multiplier for the MAD. Default is 1.4826 * 3.}
}
\value{
A logical vector.
}
\description{
Mark possible outliers using the median absolute deviation (MAD) method.
}
\details{
The function calculates the median absolute deviation of the input vector and uses
it to identify possible outliers. The default constant multiplier is 1.4826 * 3, which gives
approximately the \eqn{3\sigma} of the normal distribution.
}
\examples{
x <- c(1, 2, 3, 4, 5, 100)
mad_outlier(x)
}
\seealso{
\code{\link[stats]{mad}}
}
