% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_cifti.R
\name{separate_cifti_files}
\alias{separate_cifti_files}
\title{Separate CIFTI: file names}
\usage{
separate_cifti_files(
  intent = 3006,
  brainstructures = c("left", "right"),
  cortexL_fname = NULL,
  cortexR_fname = NULL,
  subcortVol_fname = NULL,
  subcortLabs_fname = NULL,
  ROI_brainstructures = "all",
  ROIcortexL_fname = NULL,
  ROIcortexR_fname = NULL,
  ROIsubcortVol_fname = NULL,
  write_dir = NULL
)
}
\arguments{
\item{intent}{3002 (default), 3006, or 3007}

\item{brainstructures}{Character vector indicating which brain structure(s)
to obtain: \code{"left"} (left cortex), \code{"right"} (right cortex)
and/or \code{"subcortical"} (subcortex and cerebellum). Can also be
\code{"all"} (obtain all three brain structures). Default:
\code{c("left","right")} (cortex only).

If a brain structure is indicated but does not exist in the CIFTI file, a
warning will occur and that brain structure will be skipped.}

\item{cortexL_fname, cortexR_fname}{(Optional) GIFTI file names
(*.[func/label].gii) to save the [left/right] cortex data to. If not provided,
defaults to \code{"*[L/R].\[func/label\].gii"}, where * is the file name
component of \code{cifti_fname}. Will be written in \code{write_dir}.

dtseries and dscalar files should use "func", whereas dlabel files should
use "label".}

\item{subcortVol_fname, subcortLabs_fname}{(Optional) NIFTI file names to save
the subcortical [volume/labels] to. If not provided, defaults to
\code{"*[/.labels].nii"}, where * is the file name component of
\code{cifti_fname}. Will be written in \code{write_dir}.}

\item{ROI_brainstructures}{Which ROIs should be obtained? \code{"all"}
(default) to obtain ROIs for each of the \code{brainstructures}. \code{NULL}
to not obtain any ROIs. This should be a subset of \code{brainstructures}.}

\item{ROIcortexL_fname, ROIcortexR_fname}{(Optional) GIFTI file names
(*.[func/label].gii) to save the [left/right] cortex ROI to. If not provided,
defaults to \code{"*ROI_[L/R].\[func/label\].gii"}, where * is the file name component
of \code{cifti_fname}. The cortical ROIs typically represent the medial wall
mask, with values of 1 for in-ROI (non-medial wall) vertices and 0 for
out-of-ROI (medial wall) vertices. Will be written in \code{write_dir}.

dtseries and dscalar files should use "func", whereas dlabel files should
use "label".}

\item{ROIsubcortVol_fname}{(Optional) NIFTI file names to save
the subcortical ROI to. If not provided, defaults to
\code{"*ROI.nii"}, where * is the file name component of
\code{cifti_fname}. The subcortical ROI typically represents the volumetric
mask for the entire subcortical structure, with values of 1 for in-ROI
(in subcortex) voxels and 0 for out-of-ROI (not in subcortex) voxels. Will
be written in \code{write_dir}.}

\item{write_dir}{Where should the separated files be placed? \code{NULL}
(default) will write them to the current working directory.

\code{write_dir} must already exist, or an error will occur.}
}
\value{
List of three: \code{do}, \code{ROI_do}, and \code{sep_fnames}
}
\description{
File paths for writing GIFTI and NIFTI files from a CIFTI or \code{"xifti"}
}
\keyword{internal}
