% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{movingEDistance}
\alias{movingEDistance}
\title{Moving energy distance}
\usage{
movingEDistance(x, y, l = NULL, tao = NULL)
}
\arguments{
\item{x}{matrix of regressors with variables in columns and observations in rows}

\item{y}{matrix of responses with variables in columns and observations in rows}

\item{l}{approximate number of contributing variables (Default : overall number of regressors)}

\item{tao}{length of a splitting period (Default: l*10, which is dictated by The general rule of thumb \insertCite{Harrell}{changedetection})}
}
\value{
a list of energy distnce values for pairs of adjacent data segments of length tao (moving-frame construction)
}
\description{
Estimates energy distance \insertCite{rizzo-szekely10}{changedetection} for each point starting from \code{tao+1} to \code{T-tao}, where \code{T} is a data length. In these terms, energy distance for a point means energy distance between the dataset containing \code{tao} observations to the left and the dataset containing \code{tao} observations to the right of the original point. Hence, we are considering a so-called 'moving frame' of length \code{2tao}. The resulting array shows how the energy distance behaves along the period to analyze.
}
\examples{
T<-60
change<-35
x<-rnorm(n=T, m=0, sd=1)
e<-scale(rt(n=T,3), scale=FALSE)
y1<-5*x[1:(change-1)]+e[1:(change-1)]
y2<--2*x[change:T]+e[change:T]
y<-c(y1,y2)

movingEDistance <- movingEDistance(x=as.data.frame(x),
                                   y=as.data.frame(y))
}
\references{
\insertAllCited
}
