% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdgd0_pa.R
\name{cdgd0_pa}
\alias{cdgd0_pa}
\title{Perform unconditional decomposition via parametric models}
\usage{
cdgd0_pa(Y, D, G, X, data, alpha = 0.05, trim = 0, weight = NULL)
}
\arguments{
\item{Y}{Outcome. The name of a numeric variable (can be binary and take values of 0 and 1).}

\item{D}{Treatment status. The name of a binary numeric variable taking values of 0 and 1.}

\item{G}{Advantaged group membership. The name of a binary numeric variable taking values of 0 and 1.}

\item{X}{Confounders. A vector of variable names.}

\item{data}{A data frame.}

\item{alpha}{1-alpha confidence interval.}

\item{trim}{Threshold for trimming the propensity score. When trim=a, individuals with propensity scores lower than a or higher than 1-a will be dropped.}

\item{weight}{Sampling weights. The name of a numeric variable. If unspecified, equal weights are used. Technically, the weight should be a deterministic function of X and G.}
}
\value{
A list of estimates.
}
\description{
Perform unconditional decomposition via parametric models
}
\examples{
data(exp_data)

results <- cdgd0_pa(
Y="outcome",
D="treatment",
G="group_a",
X=c("Q","confounder"),
data=exp_data)

results[[1]]
}
