% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectionMaps.R
\name{detectionMaps}
\alias{detectionMaps}
\title{Generate maps of observed species richness and species presences by station}
\usage{
detectionMaps(
  CTtable,
  recordTable,
  Xcol,
  Ycol,
  backgroundPolygon,
  stationCol = "Station",
  speciesCol = "Species",
  speciesToShow,
  richnessPlot = TRUE,
  speciesPlots = TRUE,
  addLegend = TRUE,
  printLabels = FALSE,
  smallPoints,
  plotR = TRUE,
  writePNG = FALSE,
  plotDirectory,
  createPlotDir = FALSE,
  pngMaxPix = 1000,
  writeShapefile = FALSE,
  shapefileName,
  shapefileDirectory,
  shapefileProjection
)
}
\arguments{
\item{CTtable}{data.frame. contains station IDs and coordinates}

\item{recordTable}{data.frame. the record table created by
\code{\link{recordTable}}}

\item{Xcol}{character. name of the column specifying x coordinates in
\code{CTtable}}

\item{Ycol}{character. name of the column specifying y coordinates in
\code{CTtable}}

\item{backgroundPolygon}{SpatialPolygons or SpatialPolygonsDataFrame.
Polygon to be plotted in the background of the map (e.g. project area
boundary)}

\item{stationCol}{character. name of the column specifying station ID in
\code{CTtable} and \code{recordTable}}

\item{speciesCol}{character. name of the column specifying species in
\code{recordTable}}

\item{speciesToShow}{character. Species to include in the maps. If missing,
all species in \code{recordTable} will be included.}

\item{richnessPlot}{logical. Generate a species richness plot?}

\item{speciesPlots}{logical. Generate plots of all species number of
independent events?}

\item{addLegend}{logical. Add legends to the plots?}

\item{printLabels}{logical. Add station labels to the plots?}

\item{smallPoints}{numeric. Number by which to decrease point sizes in plots
(optional).}

\item{plotR}{logical. Create plots in R graphics device?}

\item{writePNG}{logical. Create PNGs of the plots?}

\item{plotDirectory}{character. Directory in which to save the PNGs}

\item{createPlotDir}{logical. Create \code{plotDirectory}?}

\item{pngMaxPix}{integer. number of pixels in pngs on the longer side}

\item{writeShapefile}{logical. Create a shapefile from the output?}

\item{shapefileName}{character. Name of the shapefile to be saved. If empty,
a name will be generated automatically.}

\item{shapefileDirectory}{character. Directory in which to save the
shapefile.}

\item{shapefileProjection}{character. A character string of projection
arguments to use in the shapefile.}
}
\value{
An invisible \code{data.frame} with station coordinates, numbers of
events by species at each station and total species number by station. In
addition and optionally, R graphics or png image files.
}
\description{
Generates maps of observed species richness and species presence by species
and station. Output can be R graphics, PNG graphics or a shapefile for use
in GIS software.
}
\details{
The column name \code{stationCol} must be identical in \code{CTtable} and
\code{recordTable} and station IDs must match.

Shapefile creation depends on the packages \pkg{sf}.
Argument \code{shapefileProjection} must be a valid argument of
\code{\link[sf]{st_crs}} (one of (i) character: a string accepted by GDAL, 
(ii) integer, a valid EPSG value (numeric), or (iii) an object of class crs.
If \code{shapefileProjection} is undefined,
the resulting shapefile will lack a coordinate reference system.
}
\examples{


# load station information
data(camtraps)

# load record table
data(recordTableSample)


# create maps
Mapstest <- detectionMaps(CTtable           = camtraps,
                          recordTable       = recordTableSample,
                          Xcol              = "utm_x",
                          Ycol              = "utm_y",
                          stationCol        = "Station",
                          speciesCol        = "Species",
                          writePNG          = FALSE,
                          plotR             = TRUE,
                          printLabels       = TRUE,
                          richnessPlot      = TRUE,
                          addLegend         = TRUE
)



# with a polygon in the background, and for one species only

# make a dummy polygon for the background
library(sf)

Sr1 = st_polygon(list(cbind(c(521500,526500,527000, 521500, 521500),
                            c(607500, 608000, 603500, 603500, 607500))))
aoi <- data.frame(name = "My AOI")
st_geometry(aoi) <- st_geometry(Sr1)
st_crs(aoi) <- 32650  # assign CRS: UTM50N

Mapstest2 <- detectionMaps(CTtable           = camtraps,
                           recordTable       = recordTableSample,
                           Xcol              = "utm_x",
                           Ycol              = "utm_y",
                           backgroundPolygon = aoi,               # this was added
                           speciesToShow     = c("PBE", "VTA"),   # this was added
                           stationCol        = "Station",
                           speciesCol        = "Species",
                           writePNG          = FALSE,
                           plotR             = TRUE,
                           printLabels       = TRUE,
                           richnessPlot      = TRUE,
                           addLegend         = TRUE
)




}
\references{
A great resource for coordinate system information
is \url{https://spatialreference.org/}. Use the Proj4 string as
\code{shapefileProjection} argument.
}
\author{
Juergen Niedballa
}
