% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_simulation_results}
\alias{get_simulation_results}
\title{Get Results from Arena CSV Files}
\usage{
get_simulation_results(source, source_type = "path")
}
\arguments{
\item{source}{The path where csv files is stored, or a list coming from shiny. If you do not provide a value, I'll assume they're on your current working directory.}

\item{source_type}{String that describes where the data is coming from. "path" stands for a path that contains all csv files. "shinyInput" stands for the list object returned by fileInput in the ShinyApp.}
}
\value{
a tidy dataframe with simulation results.
}
\description{
This function reads all csv files inside the provided path and returns a data.frame with the simulation runs, consolidated.
You should provide a path containing only csv files generated by Arena, with the same number of replications. I Suggest you to name your csv files after your scenarios.
}
\examples{
# Define de path where your csv files are:
path <- system.file("extdata", package = "arena2r")
simulation_results = get_simulation_results(path)
head(simulation_results)
}
