% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{sp_rel_xref}
\alias{sp_rel_xref}
\title{Lookup function for shorthand versions of spatial relation text strings}
\usage{
sp_rel_xref(x)
}
\arguments{
\item{x}{A character string. One of "contains", "crosses",
"envelopeintersects", "indexintersects", "intersects", "overlaps",
"relation", "touches", "within"}
}
\value{
The appropriately named ESRI version of \code{x}. For example,
an \code{x} value of "intersects" returns "esriSpatialRelIntersects"
}
\description{
After typing "esriSpatialRelIntersects" into 4 to 5 functions, you'll get
pretty sick of typing that. This function serves to allow shorthand strings
to be passed to the \code{sp_rel} arguments of the
\code{\link{get_layers_by_spatial}} family of functions. For example, you can
pass  "intersects" to this function and it will return
"esriSpatialRelIntersects"
}
\examples{
sp_rel_xref("intersects")
}
