% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-geometry.R
\name{as_extent}
\alias{as_extent}
\title{Convert an object to an extent}
\usage{
as_extent(x, crs = sf::st_crs(x), call = rlang::caller_env())
}
\arguments{
\item{x}{an sf or sfc object}

\item{crs}{the CRS of the object. Must be parsable by \code{sf::st_crs()}}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
An extent json object. Use \code{jsonify::to_json(x, unbox = TRUE)} to convert
to json.
}
\description{
Given an sf or sfc object create a list that represents the extent of the
object. The result of this function can be parsed directly into json using
\code{jsonify::to_json(x, unbox = TRUE)} or included into a list as the extent
component that will be eventually converted into json using the above function.
}
\examples{
nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
as_extent(nc)
}
