% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_to_center.R
\name{dist_cent}
\alias{dist_cent}
\alias{distance_to_center}
\alias{distance_to_center.track_xy}
\alias{distance_to_centers}
\alias{distance_to_centers.track_xy}
\title{Distance to center}
\usage{
distance_to_center(x, ...)

\method{distance_to_center}{track_xy}(x, trast, square = TRUE, ...)

distance_to_centers(x, ...)

\method{distance_to_centers}{track_xy}(x, trast, top_n = 10, square = TRUE,
  ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{mk_track} or \code{track}.}

\item{...}{Further arguments, none implemented.}

\item{trast}{\code{[RasterLayer]} \cr A template.}

\item{square}{\code{[logical(1)]} \cr Should the distance be squared?}

\item{top_n}{\code{[integer(1)]} \cr To how many centers should the distance be
calculated?}
}
\value{
\code{RasterLayer}
}
\description{
Distances to frequently used areas. \code{distance_to_center} calculates the
distance to the home-range center (i.e., the centroid of the \code{x} and \code{y}
coordinates). \code{distance_to_centers} calculates the distance to \code{top_n} most
frequently used cells. Note, that the results of \code{distance_to_center} is
different to \code{distance_to_centers} with \code{top_n = 1}, since in the first case
the distance to the centroid is calculated and in the second case the
distance to the raster cell with the most relocations.
}
\examples{
data(deer)
r <- raster::raster(bbox(deer, buffer = 100), res = 40)
d1 <- distance_to_center(deer, r)
d2 <- distance_to_centers(deer, r, top_n = 1)
d3 <- distance_to_centers(deer, r, top_n = 10)
}
