% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{coercion}
\alias{coercion}
\alias{as_sp}
\alias{as_sp.steps_xy}
\alias{as_move}
\alias{as_move.track_xy}
\alias{as_move.track_xyt}
\alias{as_ltraj}
\alias{as_ltraj.track_xy}
\alias{as_ltraj.track_xyt}
\alias{as_bcpa}
\alias{as_bcpa.track_xyt}
\alias{as_moveHMM}
\alias{as_moveHMM.track_xy}
\title{Coerce a track to other formats.}
\usage{
as_sp(x, ...)

\method{as_sp}{steps_xy}(x, end = TRUE, ...)

as_move(x, ...)

\method{as_move}{track_xy}(x, ...)

\method{as_move}{track_xyt}(x, ...)

as_ltraj(x, ...)

\method{as_ltraj}{track_xy}(x, id = "animal_1", ...)

\method{as_ltraj}{track_xyt}(x, ...)

as_bcpa(x, ...)

\method{as_bcpa}{track_xyt}(x, ...)

as_moveHMM(x, ...)

\method{as_moveHMM}{track_xy}(x, ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{mk_track} or \code{track}.}

\item{...}{Further arguments, none implemented.}

\item{end}{\code{[logical(1)=TRUE]} \cr For steps, should the end or start points be used?}

\item{id}{\code{[numeric,character,factor]} \cr Animal id(s).}
}
\description{
Several other packages provides methods to analyse movement data, and \code{amt} provides coercion methods to some packages
}
\examples{
data(deer)
as_move(deer)
as_move(deer, id = "foo")
data(deer)
as_ltraj(deer)
as_ltraj(deer, id = "animal_3")
data(deer)
d <- as_bcpa(deer)
\dontrun{
bcpa1 <- bcpa::WindowSweep(d, "Theta", K = 2, windowsize = 50)
plot(bcpa1, type = "flat", clusterwidth = 1)
}
# Fit HMM with two states
data(deer)
dm <- as_moveHMM(deer)
\dontrun{
mu0 <- rep(mean(dm$step, na.rm = TRUE), 2) # step mean (two parameters: one for each state)
sigma0 <- rep(sd(dm$step, na.rm = TRUE), 2) # step SD
zeromass0 <- c(0.1, 0.05) # step zero-mass
stepPar0 <- c(mu0, sigma0, zeromass0)
angleMean0 <- c(pi, pi) # angle mean
kappa0 <- c(1, 1) # angle concentration
anglePar0 <- c(angleMean0, kappa0) ## call to fitting function
m1 <- fitHMM(data = dm, nbStates = 2,
       stepPar0 = stepPar0, anglePar0 = anglePar0, formula = ~ 1)
}

}
