% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Carmichael.R
\name{Carmichael}
\alias{Carmichael}
\alias{A002997}
\title{Carmichael numbers}
\usage{
Carmichael(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A002997}{A002997}, a \emph{Carmichael} number is
a composite number \eqn{n} such that
\deqn{b^{n-1} = 1 (mod n)}
for all integers \eqn{b} which are relatively prime to \eqn{n}. First 6 Carmichael numbers are  	561, 1105, 1729, 2465, 2821, 6601.
}
\examples{
## generate first 3 Carmichael numbers
first3 = Carmichael(3)

## print without trailing 0's.
print(first3, drop0trailing = TRUE)

}
