% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimuFwer.R
\name{SimuFwer}
\alias{SimuFwer}
\title{Simulates Gaussian data with a given correlation matrix and applies a FWER controlling procedure on the correlations.}
\usage{
SimuFwer(corr_theo, n = 100, Nsimu = 1, alpha = 0.05,
  stat_test = "empirical", method = "MaxTinfty", Nboot = 1000,
  stepdown = TRUE, seed = NULL)
}
\arguments{
\item{corr_theo}{the correlation matrix of Gaussien data simulated}

\item{n}{sample size}

\item{Nsimu}{number of simulations}

\item{alpha}{level of multiple testing}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{\eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{\eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
  \item{'gaussian'}{\eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}}
}}

\item{method}{choice between 'Bonferroni', 'Sidak', 'BootRW', 'MaxTinfty'}

\item{Nboot}{number of iterations for Monte-Carlo of bootstrap quantile evaluation}

\item{stepdown}{logical, if TRUE a stepdown procedure is applied}

\item{seed}{seed for the Gaussian simulations}
}
\value{
Returns a line vector containing estimated fwer, estimated fdr, estimated power, estimated true discovery rate.
}
\description{
Simulates Gaussian data with a given correlation matrix and applies a FWER controlling procedure on the correlations.
}
\examples{
Nsimu <- 1000 
n <- 100
p <- 10
corr_theo <- diag(1,p)
alpha <- 0.05
res <- SimuFwer(corr_theo,n,Nsimu,alpha,stat_test='empirical',method='Bonferroni',stepdown=FALSE)
}
\references{
Bonferroni, C. E. (1935). Il calcolo delle assicurazioni su gruppi di teste. Studi in onore del professore salvatore ortu carboni, 13-60.

Drton, M., & Perlman, M. D. (2007). Multiple testing and error control in Gaussian graphical model selection. Statistical Science, 22(3), 430-449.

Romano, J. P., & Wolf, M. (2005). Exact and approximate stepdown methods for multiple hypothesis testing. Journal of the American Statistical Association, 100(469), 94-108.

Roux, M. (2018). Graph inference by multiple testing with application to Neuroimaging, Ph.D., Université Grenoble Alpes, France, https://tel.archives-ouvertes.fr/tel-01971574v1.

Westfall, P.H. & Young, S. (1993) Resampling-based multiple testing: Examples and methods for p-value adjustment, John Wiley & Sons, vol. 279.
}
\seealso{
ApplyFwerCor, SimuFwer_oracle, SimuFdr
}
