% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sunrise_sunset.R
\name{sunrise_sunset}
\alias{sunrise_sunset}
\title{Get sunrise and sunset data for one day at US airport location from TSA API}
\usage{
sunrise_sunset(the_airport_code, the_date = Sys.Date())
}
\arguments{
\item{the_airport_code}{string valid 3-letter US airport code. See http://bit.ly/USAirportCodes for full list.}

\item{the_date}{string or date object in yyyy-mm-dd format. Defaults to current date.}
}
\value{
list with Sunrise, Sunset, Date, Location
}
\description{
Get sunrise and sunset data for one day at US airport location from TSA API
}
\examples{
\dontrun{
sunrise_sunset("BOS")
sunrise_sunset("JFK", "2019-12-22")
}
}
