% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\name{events}
\alias{events}
\title{Extract the events from a \code{SimInf_model} object}
\usage{
events(model)
}
\arguments{
\item{model}{The \code{model} to extract the events from.}
}
\value{
\code{\linkS4class{SimInf_events}} object.
}
\description{
Extract the scheduled events from a \code{SimInf_model} object.
}
\examples{
## Create an SIR model that includes scheduled events.
model <- SIR(u0     = u0_SIR(),
             tspan  = 1:(4 * 365),
             events = events_SIR(),
             beta   = 0.16,
             gamma  = 0.077)

## Extract the scheduled events from the model and display summary
summary(events(model))

## Extract the scheduled events from the model and plot them
plot(events(model))
}
