% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.SimDesign.R
\name{subset.SimDesign}
\alias{subset.SimDesign}
\title{Subset method for SimDesign objects}
\usage{
\method{subset}{SimDesign}(x, subset, select, drop = FALSE, ...)
}
\arguments{
\item{x}{A \code{data.frame} object, of class \code{SimDesign}.}

\item{subset}{A logical expression indicating elements or rows to keep.}

\item{select}{An expression, indicating columns to select from a dataframe.}

\item{drop}{Additional arguments passed on to [ indexing operator.}

\item{...}{Further arguments to be passed to or from other methods.}
}
\value{
A \code{data.frame} object.
}
\description{
\code{subset.SimDesign} is a default method for subsetting a
\code{data.frame} of class \code{SimDesign}. This is a modification
of the base R subset command to maintain the extra attributes
produced during a simulation.
}
\examples{
\dontrun{
data("BF_sim")
x <- subset(BF_sim, select = 1:6)
attributes(x)

x1 <- subset(BF_sim, select = c(1,2,4,5,10))
attributes(x1)

x2 <- subset(BF_sim, select = var_ratio:alpha.05.Jacknife)
attributes(x2)

x3 <- subset(BF_sim, var_ratio == 1)
dim(BF_sim)
dim(x3)
}

}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{SimDesign}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
