% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{SaveSeuratRds}
\alias{SaveSeuratRds}
\alias{LoadSeuratRds}
\title{Save and Load \code{Seurat} Objects from Rds files}
\usage{
SaveSeuratRds(
  object,
  file = NULL,
  move = TRUE,
  destdir = deprecated(),
  relative = FALSE,
  ...
)

LoadSeuratRds(file, ...)
}
\arguments{
\item{object}{A \code{\link{Seurat}} object}

\item{file}{Path to save \code{object} to; defaults to
\code{file.path(getwd(), paste0(Project(object), ".Rds"))}}

\item{move}{Move on-disk layers into \code{dirname(file)}}

\item{destdir}{\Sexpr[stage=build,results=rd]{lifecycle::badge("deprecated")}}

\item{relative}{Save relative paths instead of absolute ones}

\item{...}{
  Arguments passed on to \code{\link[base:readRDS]{base::saveRDS}}, \code{\link[base:readRDS]{base::readRDS}}
  \describe{
    \item{\code{ascii}}{a logical.  If \code{TRUE} or \code{NA}, an ASCII
    representation is written; otherwise (default), a binary one is used.
    See the comments in the help for \code{\link[base]{save}}.}
    \item{\code{version}}{the workspace format version to use.  \code{NULL}
    specifies the current default version (3). The only other supported
    value is 2, the default from \R 1.4.0 to \R 3.5.0.}
    \item{\code{compress}}{a logical specifying whether saving to a named file is
    to use \code{"gzip"} compression, or one of \code{"gzip"},
    \code{"bzip2"} or \code{"xz"} to indicate the type of compression to
    be used.  Ignored if \code{file} is a connection.}
    \item{\code{refhook}}{a hook function for handling reference objects.}
  }}
}
\value{
Invisibly returns \code{file}
}
\description{
Save and Load \code{Seurat} Objects from Rds files
}
\note{
This function requires the
\href{https://cran.r-project.org/package=fs}{\pkg{fs}} package
to be installed
}
\section{Progress Updates with \pkg{progressr}}{

This function uses
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars. To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-intro.html}{\code{vignette("progressr-intro")}}
}

\examples{
if (requireNamespace("fs", quietly = TRUE)) {
  # Write out with DelayedArray
  if (requireNamespace("HDF5Array", quietly = TRUE)) {
    pbmc <- pbmc_small

    pbmc[["disk"]] <- CreateAssay5Object(list(
      mem = LayerData(pbmc, "counts"),
      disk = as(LayerData(pbmc, "counts"), "HDF5Array")
    ))

    # Save `pbmc` to an Rds file
    out <- tempfile(fileext = ".Rds")
    SaveSeuratRds(pbmc, file = out)

    # Object cache
    obj <- readRDS(out)
    Tool(obj, "SaveSeuratRds")

    # Load the saved object with on-disk layers back into memory
    pbmc2 <- LoadSeuratRds(out)
    pbmc2
    pbmc2[["disk"]]
  }

  # Write out with BPCells
  if (requireNamespace("BPCells", quietly = TRUE)) {
    pbmc <- pbmc_small

    bpm <- BPCells::write_matrix_dir(LayerData(pbmc, "counts"), dir = tempfile())
    bph <- BPCells::write_matrix_hdf5(
      LayerData(pbmc, "counts"),
      path = tempfile(fileext = ".h5"),
      group = "counts"
    )
    pbmc[["disk"]] <- CreateAssay5Object(list(dir = bpm, h5 = bph))

    # Save `pbmc` to an Rds file
    out <- tempfile(fileext = ".Rds")
    SaveSeuratRds(pbmc, file = out)

    # Object cache
    obj <- readRDS(out)
    Tool(obj, "SaveSeuratRds")

    # Load the saved object with on-disk layers back into memory
    pbmc2 <- LoadSeuratRds(out)
    pbmc2
    pbmc2[["disk"]]
  }
}

}
\seealso{
\code{\link{saveRDS}()} \code{\link{readRDS}()}
}
\concept{utils}
