#' US State Map
#'
#' US state boundaries from the US Census Bureau's MAF/TIGER geographic database in EPSG:4269, with all data except state FIPS codes and land area removed.
#'
#' @format A \code{sf]{DataFrame}} object
#'
#' @references United States Census Bureau. Data accessed from the US Census Bureau website: https://www2.census.gov/geo/tiger/GENZ2018/shp/cb_2018_us_county_20m.zip; accessed 13 March 2020
#'
#' @docType data
#' @keywords datasets
#' @name us_4269
#' @usage data('us_4269')
#' @source \href{https://www.census.gov/geographies/mapping-files.html}{US Census Bureau}
#'

'us_4269'
