% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPAS.print.model.legacy.R
\name{SPAS.print.model.legacy}
\alias{SPAS.print.model.legacy}
\title{Print the results from a fit of a Stratified-Petersen (SP) model from the legacy (i.e. pre using TMB) code}
\usage{
SPAS.print.model.legacy(x)
}
\arguments{
\item{x}{A result from the model fitting. See \code{SPAS.fit.model}.}
}
\value{
A report to the console. Refer to the vignettes.
}
\description{
This function makes a report of the results of the model fitting
.
}
\examples{
conne.data.csv <- textConnection("
9  ,    21  ,     0  ,    0  ,    0  ,    0  ,   171
0  ,   101  ,    22  ,    1  ,    0  ,    0  ,   763
0  ,     0  ,   128  ,   49  ,    0  ,    0  ,   934
0  ,     0  ,     0  ,   48  ,   12  ,    0  ,   434
0  ,     0  ,     0  ,    0  ,    7  ,    0  ,    49
0  ,     0  ,     0  ,    0  ,    0  ,    0  ,     4
351,  2736  ,  3847  , 1818  ,  543  ,   191 ,     0")
conne.data <- as.matrix(read.csv(conne.data.csv, header=FALSE))
close(conne.data.csv)
 
mod1 <- SPAS.fit.model.legacy(conne.data, model.id="Pooling rows 1/2, 5/6; pooling columns 5/6",
                      row.pool.in=c("12","12","3","4","56","56"),
                      col.pool.in=c(1,2,3,4,56,56),
                      optMethod.control=list(ftol=.0001))

SPAS.print.model.legacy(mod1)
}
