% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAP_funcs.R
\name{shap.prep.stack.data}
\alias{shap.prep.stack.data}
\title{Prepare data for SHAP force plot (stack plot)}
\usage{
shap.prep.stack.data(
  shap_contrib,
  top_n = NULL,
  data_percent = 1,
  cluster_method = "ward.D",
  n_groups = 10L
)
}
\arguments{
\item{shap_contrib}{shap_contrib is the SHAP value data returned from
predict, here an ID variable is added for each observation in
the \code{shap_contrib} dataset for better tracking, it is created in the
begining as \code{1:nrow(shap_contrib)}. The ID matches the output from
\code{\link{shap.prep}}}

\item{top_n}{integer, optional to show only top_n features, combine the rest}

\item{data_percent}{what percent of data to plot (to speed up the testing
plot). The accepted input range is (0,1], if observations left is too few,
there will be an error from the clustering function}

\item{cluster_method}{default to ward.D, please refer to \code{stats::hclust} for
details}

\item{n_groups}{a integer, how many groups to plot in
\code{\link{shap.plot.force_plot_bygroup}}}
}
\value{
a dataset for stack plot
}
\description{
Make force plot for \code{top_n} features, optional to randomly plot certain
portion of the data in case the dataset is large.
}
\examples{

# **SHAP force plot**
plot_data <- shap.prep.stack.data(shap_contrib = shap_values_iris,
                                  n_groups = 4)
shap.plot.force_plot(plot_data)
shap.plot.force_plot(plot_data,  zoom_in_group = 2)

# plot all the clusters:
shap.plot.force_plot_bygroup(plot_data)
}
