% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_DimPlot.R
\name{do_DimPlot}
\alias{do_DimPlot}
\title{Wrapper for \link[Seurat]{DimPlot}.}
\usage{
do_DimPlot(
  sample,
  reduction = NULL,
  group.by = NULL,
  split.by = NULL,
  colors.use = NULL,
  shuffle = TRUE,
  order = NULL,
  pt.size = 1,
  label = FALSE,
  label.color = "white",
  repel = TRUE,
  cells.highlight = NULL,
  idents.highlight = NULL,
  idents.keep = NULL,
  sizes.highlight = 1,
  ncol = NULL,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  legend.title = NULL,
  legend.position = "bottom",
  legend.title.position = "top",
  legend.ncol = NULL,
  legend.nrow = NULL,
  legend.icon.size = 4,
  legend.byrow = FALSE,
  raster = FALSE,
  raster.dpi = 1024,
  dims = c(1, 2),
  font.size = 14,
  font.type = "sans",
  na.value = "grey75",
  plot_cell_borders = TRUE,
  border.size = 2,
  border.color = "black",
  plot_marginal_distributions = FALSE,
  marginal.type = "density",
  marginal.size = 5,
  marginal.group = TRUE,
  plot.axes = FALSE
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{reduction}{\strong{\code{\link[base]{character}}} | Reduction to use. Can be the canonical ones such as "umap", "pca", or any custom ones, such as "diffusion". If you are unsure about which reductions you have, use \code{Seurat::Reductions(sample)}. Defaults to "umap" if present or to the last computed reduction if the argument is not provided.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Secondary metadata variable to further group (split) the output by. Has to be a character of factor column.}

\item{colors.use}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of valid color representations (either name of HEX codes) with as many named colors as unique values of group.by. If group.by is not provided, defaults to the unique values of \link[Seurat]{Idents}. If not provided, a color scale will be set by default.}

\item{shuffle}{\strong{\code{\link[base]{logical}}} | Whether to shuffle the cells or not, so that they are not plotted cluster-wise. Recommended.}

\item{order}{\strong{\code{\link[base]{character}}} | Vector of identities to be plotted. Either one with all identities or just some, which will be plotted last.}

\item{pt.size}{\strong{\code{\link[base]{numeric}}} | Size of the dots.}

\item{label}{\strong{\code{\link[base]{logical}}} | Whether to plot the cluster labels in the UMAP. The cluster labels will have the same color as the cluster colors.}

\item{label.color}{\strong{\code{\link[base]{character}}} | HEX code for the color of the text in the labels if label is set to TRUE.}

\item{repel}{\strong{\code{\link[base]{logical}}} | Whether to repel the labels if label is set to TRUE.}

\item{cells.highlight, idents.highlight}{\strong{\code{\link[base]{character}}} | Vector of cells/identities to focus into. The identities have to much those in \code{Seurat::Idents(sample)} The rest of the cells will be grayed out. Both parameters can be used at the same time.}

\item{idents.keep}{\strong{\code{\link[base]{character}}} | Vector of identities to keep. This will effectively set the rest of the cells that do not match the identities provided to NA, therefore coloring them according to na.value parameter.}

\item{sizes.highlight}{\strong{\code{\link[base]{numeric}}} | Point size of highlighted cells using cells.highlight parameter.}

\item{ncol}{\strong{\code{\link[base]{numeric}}} | Number of columns used in the arrangement of the output plot using "split.by" parameter.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.title.position}{\strong{\code{\link[base]{character}}} | Position for the title of the legend. One of:
\itemize{
\item \emph{\code{top}}: Top of the legend.
\item \emph{\code{bottom}}: Bottom of the legend.
\item \emph{\code{left}}: Left of the legend.
\item \emph{\code{right}}: Right of the legend.
}}

\item{legend.ncol, legend.nrow}{\strong{\code{\link[base]{numeric}}} | Number of columns/rows in the legend.}

\item{legend.icon.size}{\strong{\code{\link[base]{numeric}}} | Size of the icons in legend.}

\item{legend.byrow}{\strong{\code{\link[base]{logical}}} | Whether the legend is filled by row or not.}

\item{raster}{\strong{\code{\link[base]{logical}}} | Whether to raster the resulting plot. This is recommendable if plotting a lot of cells.}

\item{raster.dpi}{\strong{\code{\link[base]{numeric}}} | Pixel resolution for rasterized plots. Defaults to 1024.}

\item{dims}{\strong{\code{\link[base]{numeric}}} | Vector of 2 numerics indicating the dimensions to plot out of the selected reduction. Defaults to c(1, 2) if not specified.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{plot_cell_borders}{\strong{\code{\link[base]{logical}}} | Whether to plot border around cells.}

\item{border.size}{\strong{\code{\link[base]{numeric}}} | Width of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color to use for the border of the cells.}

\item{plot_marginal_distributions}{\strong{\code{\link[base]{logical}}} |  Whether to plot marginal distributions on the figure or not.}

\item{marginal.type}{\strong{\code{\link[base]{character}}} | One of:
\itemize{
\item \emph{\code{density}}: Compute density plots on the margins.
\item \emph{\code{histogram}}: Compute histograms on the margins.
\item \emph{\code{boxplot}}: Compute boxplot on the margins.
\item \emph{\code{violin}}: Compute violin plots on the margins.
\item \emph{\code{densigram}}: Compute densigram plots on the margins.
}}

\item{marginal.size}{\strong{\code{\link[base]{numeric}}} | Size ratio between the main and marginal plots. A value of 5 means that the main plot is 5 times bigger than the marginal plots.}

\item{marginal.group}{\strong{\code{\link[base]{logical}}} | Whether to group the marginal distribution by group.by or current identities.}

\item{plot.axes}{\strong{\code{\link[base]{logical}}} | Whether to plot axes or not.}
}
\value{
A ggplot2 object containing a DimPlot.
}
\description{
Wrapper for \link[Seurat]{DimPlot}.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_DimPlot", passive = TRUE)

  if (isTRUE(value)){
    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic DimPlot.
    p <- SCpubr::do_DimPlot(sample = sample)

    # Control dimensions.
    p <- SCpubr::do_DimPlot(sample = sample,
                            plot.title = "My awesome SC data set",
                            dims = c(2, 1))

    # Include a plot title.
    p <- SCpubr::do_DimPlot(sample = sample,
                            plot.title = "My awesome SC data set")

    # Include a plot subtitle.
    p <- SCpubr::do_DimPlot(sample = sample,
                            plot.subtitle = "My awesome SC data set")

    # Include a plot caption
    p <- SCpubr::do_DimPlot(sample = sample,
                            plot.caption = "My awesome SC data set")

    # Control legend position and number of columns.
    p <- SCpubr::do_DimPlot(sample = sample,
                            plot.title = "My awesome SC data set",
                            legend.position = "left",
                            legend.ncol = 2)

    # Control legend position and number of rows
    p <- SCpubr::do_DimPlot(sample = sample,
                            plot.title = "My awesome SC data set",
                            legend.position = "left",
                            legend.nrow = 2)

    # Use labels instead of legend.
    p <- SCpubr::do_DimPlot(sample = sample,
                            label = TRUE,
                            legend.position = "none")

    # Changing the order of plotting.
    # Using order with one identity value.
    p <- SCpubr::do_DimPlot(sample = sample,
                            shuffle = FALSE,
                            order = "5")

    # Using order with all identity values.
    p <- SCpubr::do_DimPlot(sample = sample,
                            shuffle = FALSE,
                            order = c("5", "8", "4",
                                      "9", "3", "1",
                                      "6", "0", "7", "2"))

    # Restrict the amount of identities displayed.
    p <- SCpubr::do_DimPlot(sample = sample,
                            idents.keep = c("1", "3", "5"))


    # Group by another variable rather than `Seurat::Idents(sample)`
    p <- SCpubr::do_DimPlot(sample = sample,
                            group.by = "seurat_clusters")

    # Split the output in as many plots as unique identities.
    p <- SCpubr::do_DimPlot(sample = sample,
                            split.by = "seurat_clusters")

    # Restrict the amount of identities displayed by split.by.
    p <- SCpubr::do_DimPlot(sample = sample,
                            split.by = "seurat_clusters",
                            idents.keep = c("1", "3", "5"))

    # Modify default colors.
    # Colors need to a named vector of the same length as the identities.
    colors <- c("0" = "#001219",
                "1" = "#005f73",
                "2" = "#0a9396",
                "3" = "#94d2bd",
                "4" = "#e9d8a6",
                "5" = "#ee9b00",
                "6" = "#ca6702",
                "7" = "#bb3e03",
                "8" = "#ae2012",
                "9" = "#9b2226")
    p <- SCpubr::do_DimPlot(sample = sample,
                            colors.use = colors)

    # Highlight cells.
    # Select 1000 random cells out of clusters 1, 5 and 7.
    cells.use <- sample(colnames(sample[, sample$seurat_clusters \%in\% c("1", "5", "7")]), 50)
    p <- SCpubr::do_DimPlot(sample = sample,
                            cells.highlight = cells.use)

    # Highlight cells and use custom color.
    # Select 1000 random cells out of clusters 1, 5 and 7.
    cells.use <- sample(colnames(sample[, sample$seurat_clusters \%in\% c("1", "5", "7")]), 50)
    p <- SCpubr::do_DimPlot(sample = sample,
                            cells.highlight = cells.use,
                            colors.use = "black")

    # Change the size of the highlighted cells.
    # Select 1000 random cells out of clusters 1, 5 and 7.
    cells.use <- sample(colnames(sample[, sample$seurat_clusters \%in\% c("1", "5", "7")]), 50)
    p <- SCpubr::do_DimPlot(sample = sample,
                            cells.highlight = cells.use,
                            colors.use = "black",
                            sizes.highlight = 1)

    # Highlight given identities
    p <- SCpubr::do_DimPlot(sample,
                            idents.highlight = c("1", "3"))

    # Highlight given cells and given identities.
    cells.use <- sample(colnames(sample[, sample$seurat_clusters \%in\% c("1", "5", "7")]), 50)
    p <- SCpubr::do_DimPlot(sample,
                            cells.highlight = cells.use,
                            idents.highlight = c("2", "4"))
  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}



}
