% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getType.R
\name{getType}
\alias{getType}
\title{Relationship Types}
\usage{
getType(object)
}
\arguments{
\item{object}{A relationship or graph object.}
}
\value{
A character vector.
}
\description{
Get the type of a relationship object or all relationship types in the graph.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice")
bob = createNode(graph, "Person", name = "Bob")
charles = createNode(graph, "Person", name = "Charles")

createRel(bob, "WORKS_WITH", charles)
rel = createRel(alice, "KNOWS", bob)

getType(rel)

getType(graph)
}
}

