% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.remix.R
\name{cv.remix}
\alias{cv.remix}
\title{REMixed algorithm over a grid of \eqn{\lambda}}
\usage{
cv.remix(
  project = NULL,
  final.project = NULL,
  dynFUN,
  y,
  ObsModel.transfo,
  alpha,
  lambda.grid = NULL,
  alambda = 0.001,
  nlambda = 50,
  lambda_max = NULL,
  eps1 = 10^(-2),
  eps2 = 10^(-1),
  selfInit = FALSE,
  pop.set1 = NULL,
  pop.set2 = NULL,
  prune = NULL,
  n = NULL,
  parallel = TRUE,
  ncores = NULL,
  print = TRUE,
  digits = 3,
  trueValue = NULL,
  unlinkBuildProject = TRUE,
  max.iter = +Inf
)
}
\arguments{
\item{project}{directory of the Monolix project (in .mlxtran). If NULL, the current loaded project is used (default is NULL).}

\item{final.project}{directory of the final Monolix project (default add "_upd" to the Monolix project).}

\item{dynFUN}{function computing the dynamics of interest for a set of parameters. This function need to contain every sub-function that it may needs (as it is called in a \code{foreach} loop). The output of this function need to return a data.frame with \code{time} as first columns and named dynamics in other columns. It must take in input :
\describe{\item{\code{y}}{a named vector with the initial condition. The names are the dynamics names.}
\item{\code{parms}}{a named vector of parameter}.
\item{\code{time}}{vector a timepoint.}}

See \code{\link{dynFUN_demo}}, \code{\link{model.clairon}}, \code{\link{model.pasin}} or \code{\link{model.pk}} for examples.}

\item{y}{initial condition of the mechanism model, conform to what is asked in dynFUN.}

\item{ObsModel.transfo}{list containing two lists of transformations and two vectors linking each transformations to their observation model name in the Monolix project. The list should include identity transformations and be named \code{S} and \code{R}. The two vectors should be named \code{linkS} and \code{linkR}.

Both \code{S} (for the direct observation models) and \code{linkS}, as well as \code{R} (for latent process models) and \code{linkR}, must have the same length.

\describe{
  \item{\code{S}}{a list of transformations for the direct observation models. Each transformation corresponds to a variable \eqn{Y_p=h_p(S_p)}, where the name indicates which dynamic is observed (from \code{dynFUN});}\item{\code{linkS}}{a vector specifying the observation model names (that is used in the monolix project, \code{alpha1}, etc.) for each transformation, in the same order as in \code{S}};

  \item{\code{R}}{similarly, a list of transformations for the latent process models. Although currently there is only one latent dynamic, each \eqn{s_k, k\leq K} transformation corresponds to the same dynamic but may vary for each \eqn{Y_k} observed. The names should match the output from \code{dynFUN};} \item{\code{linkR}}{a vector specifying the observation model names for each transformation, in the same order as in \code{R}.}
}}

\item{alpha}{named list of named vector "\code{alpha0}", "\code{alpha1}" (all \code{alpha1} are mandatory). The name of \code{alpha$alpha0} and \code{alpha$alpha1} are the observation model names from the monolix project to which they are linked (if the observations models are defined whithout intercept, alpha$alpha0 need to be set to the vector NULL).}

\item{lambda.grid}{grid of user-suuplied penalisation parameters for the lasso regularization (if NULL, the sequence is computed based on the data).}

\item{alambda}{if \code{lambda.grid} is null, coefficients used to compute the grid (default to 0.05, see details).}

\item{nlambda}{if \code{lambda.grid} is null, number of lambda parameter to test (default to 50).}

\item{lambda_max}{if \code{lambda.grid} is null, maximum of the lambda grid to test (default is automatically computed, see details)}

\item{eps1}{integer (>0) used to define the convergence criteria for the regression parameters.}

\item{eps2}{integer (>0) used to define the convergence criteria for the likelihood.}

\item{selfInit}{logical, if the SAEM is already done in the monolix project should be use as the initial point of the algorithm (if FALSE, SAEM is automatically compute according to \code{pop.set1} settings ; if TRUE, a SAEM through monolix need to have been launched).}

\item{pop.set1}{population parameters setting for initialisation (see details).}

\item{pop.set2}{population parameters setting for iterations.}

\item{prune}{percentage for prunning (\eqn{\in[0;1]})  in the Adaptative Gauss-Hermite algorithm used to compute the log-likelihood and its derivates (see \code{\link{gh.LL}}).}

\item{n}{number of points for  gaussian quadrature (see \code{\link{gh.LL}}).}

\item{parallel}{logical, if the computation should be done in parallel when possible (default TRUE).}

\item{ncores}{number of cores for parallelization (default NULL and \code{\link{detectCores}} is used).}

\item{print}{logical, if the results and algotihm steps should be displayed in the console (default to TRUE).}

\item{digits}{number of digits to print (default to 3).}

\item{trueValue}{-for simulation purposes- named vector of true value for parameters.}

\item{unlinkBuildProject}{logical, if the build project of each lambda should be deleted.}

\item{max.iter}{maximum number of iteration (default 20).}
}
\value{
A list of outputs of the final project and of the iterative process over each value of \code{lambda.grid}:
\describe{
  \item{\code{info}}{Information about the parameters.}
  \item{\code{project}}{The project path if not unlinked.}
  \item{\code{lambda}}{The grid of \eqn{\lambda}.}
  \item{\code{BIC}}{Vector of BIC values for the model built over the grid of \eqn{\lambda}.}
  \item{\code{BICc}}{Vector of BICc values for the model built over the grid of \eqn{\lambda}.}
  \item{\code{LL}}{Vector of log-likelihoods for the model built over the grid of \eqn{\lambda}.}
  \item{\code{LL.pen}}{Vector of penalized log-likelihoods for the model built over the grid of \eqn{\lambda}.}
  \item{\code{res}}{List of all REMixed results for each \eqn{\lambda} (see \code{\link{remix}}).}
  \item{\code{outputs}}{List of all REMixed outputs for each \eqn{\lambda} (see \code{\link{remix}}).}
}
}
\description{
Regularization and Estimation in MIXed effects model, over a regularization path.
}
\details{
See \code{\link{REMixed-package}} for details on the model.
For each \eqn{\lambda\in\Lambda}, the \code{\link{remix}} is launched.
For population parameter estimation settings, see (<https://monolixsuite.slp-software.com/r-functions/2024R1/setpopulationparameterestimationsettings>).
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)

res = cv.remix(project = project,
               dynFUN = dynFUN_demo,
               y = y,
               ObsModel.transfo = ObsModel.transfo,
               alpha = alpha,
               selfInit = TRUE,
               eps1=10**(-2),
               ncores=8,
               nlambda=8,
               eps2=1)
}
}
