% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representative.R
\name{representative_point}
\alias{representative_point}
\title{Computes representative point based on the coordinates of points which are in
    the same group.}
\usage{
representative_point(input, ids = NULL, coord_names = c(1, 2),
  standard_error_mean = TRUE, plot = FALSE, ...)
}
\arguments{
\item{input}{A matrix which contains the coordinates of samples. Usually this is the
result of ordination of normalized RADs using multi-dimensional scaling (\code{cmdscale}).
In the input matrix each row contains vector of coordinates of one sample.}

\item{ids}{Vector of row numbers of the desired group,
from which a representative point is going to be represented}

\item{coord_names}{A vector which contains the coordintes number that should be used to create representative point.
Default is \code{c(1,2)}.}

\item{standard_error_mean}{A logical. If \code{TRUE}, uses the standard error of the mean
and plot it with representative points. It works only if \code{plot = TRUE}.}

\item{plot}{A logical. If \code{TRUE}, shows the representative points on the previous plot.}

\item{...}{other graphical parameters to use for plotting. This function uses
internally the functions \code{points} and \code{arrows} to plot.}
}
\value{
A list of following parameters:

$mean: Contains the average of points. A vector with the length of coordinates
    used for computing the average. These coordinates are preset in \code{coord_names}.

$sd: A vector with a length similar to \code{mean} which contains the
    standard deviation for each coordinate.

$mean_standard_error: A vector with a length similar to \code{mean} which
    contain the standard deviation of the mean for each coordinate. This vector is the result of \code{sd / sqrt(n)},
    when n is the number of members of the group (length of \code{sample_ids}).

If \code{plot = TRUE}, representative points would be added to the previous plot.

If \code{standard_error_mean = TRUE}, the standard error of the mean would be added to the representative points.
}
\description{
Computes representative point based on the coordinates of points which are in
    the same group.
}
\examples{
line_cols <- c("green","red","blue")
sample_classes <- c(1,1,1,1,2,2,3,3,1,1,2,3,3,1,1,2,3,3)
maxrank <- 400
data("gut_nrads")
nrads <- gut_nrads
nrads <- nrads$norm_matrix

#distance matrix using manhattan distance
d <- dist(x = nrads,method = "manhattan")
#ordination using classical multi-dimensional scaling
mds <- cmdscale(d = d,k = 5,eig = TRUE)

#plot the points
plot(mds$points,xlab = "First coordinate",ylab = "Second coordinate",pch = 19,cex =1,
    col = line_cols[sample_classes],
    main = "MDS plot with representative points \\n of each group and error bars")

#add the representative points wit erorr bar to the previous plot
a <- representative_point(input = mds$points,ids = which(sample_classes == 1),
    col = scales::alpha(line_cols[1],0.5),
    plot = TRUE,standard_error_mean = TRUE,pch = 19, cex = 4)
a <- representative_point(input = mds$points,ids = which(sample_classes == 2),
    col = scales::alpha(line_cols[2],0.5),
    plot = TRUE,standard_error_mean = TRUE,pch = 19, cex = 4)
a <- representative_point(input = mds$points,ids = which(sample_classes == 3),
    col = scales::alpha(line_cols[3],0.5),
    plot = TRUE,standard_error_mean = TRUE,pch = 19, cex = 4)

legend("bottomleft",bty = "n",legend = c("pre Cp","under Cp","post Cp"),
    col = line_cols,pch = 19)

}
\seealso{
\code{\link{RADnormalization}} for normalize an abundance vector. This function return more details compared to \code{\link{RADnormalization_matrix}},
         \code{\link{RADnormalization_matrix}} for normalize an entire otutable,
         \code{\link{representative_RAD}} for study the representative of group of norm rads.
}

