% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superpixels.R
\name{padding}
\alias{padding}
\title{Padding of matrices or n-dimensional arrays with a user specified value}
\usage{
padding(input_data, new_rows, new_cols, fill_value = 0)
}
\arguments{
\item{input_data}{either a matrix or a 3-dimensional array}

\item{new_rows}{an integer specifying the new rows of the output matrix or array}

\item{new_cols}{an integer specifying the new columns of the output matrix or array}

\item{fill_value}{a numeric value to fill the extended rows / columns of the initial input data}
}
\value{
a list
}
\description{
Padding of matrices or n-dimensional arrays with a user specified value
}
\details{
The \emph{padding} function returns a list, where \emph{data} is the padded / extended matrix or array and \emph{padded_start}, \emph{padded_end}, \emph{padded_left} and \emph{padded_right} are integer values specifying how
many rows or columsn in up-, down-, left- or right-direction the input matrix or array was padded / extended with the specified fill-value.
}
\examples{

library(OpenImageR)


#-------
# matrix
#-------

set.seed(1)
mt = matrix(runif(100), 10, 10)

res_mt = padding(mt, 15, 20, fill_value = -1)


#------
# array
#------

lst = list(matrix(1, 10, 10), matrix(2, 10, 10))

arr = List_2_Array(lst, verbose = FALSE)

res_arr = padding(arr, 15, 20, fill_value = mean(as.vector(mt)))

}
