% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSR.R
\name{CSR}
\alias{CSR}
\title{Calculate CSR strategy for multiple plant species}
\usage{
CSR(data)
}
\arguments{
\item{data}{A dataframe containing columns for LA (Leaf Area), LDMC (Leaf Dry Matter Content), and SLA (Specific Leaf Area).}
}
\value{
A dataframe with the original input data and additional columns:
\itemize{
\item C: Competitive strategy score
\item S: Stress-tolerant strategy score
\item R: Ruderal strategy score
\item type: The dominant CSR strategy type
}
}
\description{
This function processes a dataframe containing leaf traits (LA, LDMC, SLA) and applies the Strate_CSR function to each row.
}
\examples{
LA <- c(369615.7, 11.8, 55.7, 36061.2, 22391.8, 30068.1, 31059.5, 29895.1)
LDMC <- c(25.2, 39.7, 13.3, 35.5, 33.2, 36.1, 35.2, 34.9)
SLA <- c(17.4, 6.6, 34.1, 14.5, 8.1, 12.1, 9.4, 10.9)
traits <- data.frame(LA, LDMC, SLA)
CSR(data = traits)

}
\references{
\enumerate{
\item Grime, J.P. (1974). Vegetation classification by reference to strategies. Nature, 250, 26–31.
\item Pierce, S., Negreiros, D., Cerabolini, B.E.L., Kattge, J., Díaz, S., et al. (2017). A global method for calculating plant CSR ecological strategies applied across biomes world-wide. Funct Ecol, 31: 444-457.
}
}
