% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR.R
\name{VAR}
\alias{VAR}
\title{Estimates a standard VAR(1)}
\usage{
VAR(RiskFactors, VARtype, Bcon_Mat = NULL)
}
\arguments{
\item{RiskFactors}{A numeric matrix (F x T) representing the time series of risk factors.}

\item{VARtype}{String vector with two possible values: 'unconstrained' or 'constrained'.}

\item{Bcon_Mat}{Constraints matrix (F+1 x N), which includes an intercept. Entries containing NAs are treated as free parameters. \cr
Default is set to NULL.}
}
\value{
intercept, feedback matrix and the variance-covariance matrix of a VAR(1)
}
\description{
Estimates a standard VAR(1)
}
\examples{
data("CM_Factors")
# Example 1: unconstrained case
VAR(RiskFactors, VARtype= 'unconstrained')

# Example 2: constrained case
K <- nrow(RiskFactors)
Bcon_Mat <- matrix(0, nrow = K, ncol = K+1)
Bcon_Mat[ , 1:3] <- NaN
VAR(RiskFactors, VARtype= 'constrained', Bcon_Mat)

}
