% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDRSU.R
\name{GTBH.p.adjust}
\alias{GTBH.p.adjust}
\title{The adjusted p-values for Gilbert-Tarone-BH step-up FDR controlling procedure.}
\usage{
GTBH.p.adjust(p, p.set, alpha, make.decision)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{p.set}{a list of numeric vectors, where each vector is the vector of all attainable p-values containing the available p-value for the corresponding hypothesis.}

\item{alpha}{significant level used to compare with adjusted p-values to make decisions, the default value is 0.05.}

\item{make.decision}{logical; if  \code{TRUE}, then the output include the decision rules compared adjusted p-values with significant level \eqn{\alpha}}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \code{p}).
}
\description{
The function for calculating the adjusted p-values based on original available p-values and all attaianble p-values.
}
\examples{
p <- c(pbinom(1,8,0.5),pbinom(1,5,0.75),pbinom(1,6,0.6))
p.set <-list(pbinom(0:8,8,0.5),pbinom(0:5,5,0.75),pbinom(0:6,6,0.6))
GTBH.p.adjust(p,p.set)
}
\references{
Gilbert, P. B. (2005).
A modified false discovery rate multiple-comparisons procedure for discrete data, applied to human immunodeficiency virus genetics.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, \strong{54}: 143-158.

Benjamini, Y., and Hochberg, Y. (1995).
 Controlling the false discovery rate: a practical and powerful approach to multiple testing.
 \emph{Journal of the Royal Statistical Society Series B}, \strong{57}: 289-300.
}
\seealso{
\code{\link{GTBY.p.adjust}},  \code{\link{MBH.p.adjust}},  \code{\link{MBY.p.adjust}}
}
\author{
Yalin Zhu
}
