% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Incenter.R
\name{Incenter}
\alias{Incenter}
\title{Computes the incenter of a given triangle}
\usage{
Incenter(Tri, lines = F)
}
\arguments{
\item{Tri}{Triangle object, previously created with function \code{CreatePolygon}}

\item{lines}{Boolean. When \code{lines} = \code{TRUE}, the plot displays the lines that bisect each of the angles of the triangle. If missing, it works as with \code{lines} = \code{FALSE}, so the lines are not displayed}
}
\value{
Vector which contains the xy-coordinates of the incenter of the triangle
}
\description{
\code{Incenter} computes the center of a triangle
}
\examples{
P1 <- c(0,0)
P2 <- c(1,1)
P3 <- c(2,0) 
Tri <- CreatePolygon(P1, P2, P3)
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
Draw(Tri, "transparent")
I <- Incenter(Tri, lines = TRUE)
Draw(I, "red")
}
\references{
http://mathworld.wolfram.com/Incenter.html
}
