% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Duopoly.R
\name{Duopoly}
\alias{Duopoly}
\title{Plots a fractal curve from the trochoids family. Any curve from this family can be defined by some parametrical equations, but they can also be produced (approximated) through a simple iterative process based on segment drawing for certain angles and lengths}
\usage{
Duopoly(P, l1, angle1, l2, angle2, time = 0, color = "transparent")
}
\arguments{
\item{P}{Vector containing the xy-coordinates of the starting point for the curve}

\item{l1}{Number that indicates the length side of the segment drawn the first in each of the steps of the process}

\item{angle1}{Angle (0-360) that indicates the direction of the segment which is drawn the first in each of the steps of the process}

\item{l2}{Number that indicates the length side of the segment drawn the second in each of the steps of the process}

\item{angle2}{Angle (0-360) that indicates the direction of the segment which is drawn the second in each of the steps of the process}

\item{time}{Number of seconds to wait for the program before drawing each of the segments that make the trochoid curve. If no \code{time} is specified, default value is 0 (no waiting time). If the chosen time is very small (\code{time} < 0.05) it is possible that the program shows the plot directly. In this case, it should be increased the \code{time} parameter.}

\item{color}{Color to indicate the points that are obtained during the process to approximate the trochoid. If missing, the points are not indicated and only the segments are drawn in the plot}
}
\value{
None. It produces the plot of a curve from the trochoids family
}
\description{
\code{Duopoly} plots a closed curve from the trochoids family
}
\examples{
x_min <- -100
x_max <- 100
y_min <- -50
y_max <- 150
CoordinatePlane(x_min, x_max, y_min, y_max)
P <- c(0,0)
l1 <- 2
angle1 <- 3
l2 <- 2
angle2 <- 10 
Duopoly(P, l1, angle1, l2, angle2)
}
\references{
Abelson, H., & DiSessa, A. A. (1986). Turtle geometry: The computer as a medium for exploring mathematics. MIT press

Armon, U. (1996). Representing trochoid curves by DUOPOLY procedure. International Journal of Mathematical Education in Science and Technology, 27(2), 177-187
}
