% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_smoothing.R
\name{cics_unif_explicit_smooth}
\alias{cics_unif_explicit_smooth}
\title{Smooth given data set by k-component uniform clamped interpolating spline (UcICS).}
\usage{
cics_unif_explicit_smooth(
  xx,
  yy,
  k,
  clrs = c("blue", "red"),
  d,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  plotTF = TRUE
)
}
\arguments{
\item{xx}{a vector of data set's \code{x}-coordinates (that are in increasing order).}

\item{yy}{a vector of datanvidi set's \code{y}-coordinates.}

\item{k}{a chosen number of components of smoothing UcICS (integer \eqn{\ge 2}).}

\item{clrs}{a vector of colours that are used alternately to plot the graph of spline's components.}

\item{d}{a vector (optional parameter) that contains two values of derivative, in the first and the last
computed node. If missing, values of derivative are estimated by given linear regression model. If present, their
contribution is removed from linear model and only function values are estimated.}

\item{xlab}{a title (optional parameter) for the \code{x} axis.}

\item{ylab}{a title (optional parameter) for the \code{y} axis.}

\item{title}{a title (optional parameter) for the plot.}

\item{plotTF}{a boolean value (optional parameter), if TRUE then plot.}
}
\value{
a list with components
\item{nodes}{vector of equidistant nodes, based on which we construct the smoothing spline.}
\item{est_spline_coeffs}{\code{4}-element array of \code{(k)x(k+3)} matrices, whereas element in \code{i}-th row and \code{j}-th
 of \code{l}-th matrix contains coefficient by \code{x^{l-1}} of cubic polynomial, which is in \code{i}-th row and \code{j}-th column  of matrix
\code{B} from smoothing spline's explicit form \deqn{S=B.\gamma.}}
\item{est_spline_polynomials}{list of string representations of smoothing UcICS.}
\item{est_gamma}{vector of estimated smoothing spline's coefficients (function values and exterior-node derivatives).}
\item{aux_BF}{A basis function of the spline}
\item{aux_tridiag_inverse}{An inverse of the tridiagonal matrix used for spline derivatives construction}
\item{aux_M}{An estimation matrix used to compute \code{est_gamma}}
}
\description{
\code{cics_unif_explicit_smooth} constructs the uniform clamped interpolating spline with \code{k} components that smoothes
 given data set \code{{(xx[i],yy[i]), i=1..length(xx)}}.
}
\examples{

cp <- cics_unif_explicit_smooth(
xx = CERN$x,
  yy = CERN$y,
  k = 19, #23,
  d = c(1, 0),
  xlab = "X axis",
  ylab = "Y axis"
)
}
