% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_search.R
\name{resultsGreedySearch}
\alias{resultsGreedySearch}
\title{Returns the results (thus far) of the greedy design search}
\usage{
resultsGreedySearch(obj, max_vectors = 9, form = "one_zero")
}
\arguments{
\item{obj}{The \code{greedy_experimental_design} object that is currently running the search}

\item{max_vectors}{The number of design vectors you wish to return. \code{NULL} returns all of them. 
This is not recommended as returning over 1,000 vectors is time-intensive. The default is 9.}

\item{form}{Which form should it be in? The default is \code{one_zero} for 1/0's or \code{pos_one_min_one} for +1/-1's.}
}
\description{
Returns the results (thus far) of the greedy design search
}
\examples{
 \dontrun{
	library(MASS)
	data(Boston)
 #pretend the Boston data was an experiment setting 
	#first pull out the covariates
 X = Boston[, 1 : 13]
 #begin the greedy design search
	ged = initGreedyExperimentalDesignObject(X, 
		max_designs = 1000, num_cores = 2, objective = "abs_sum_diff")
	#wait
	res = resultsGreedySearch(ged, max_vectors = 2)
	design = res$ending_indicTs[, 1] #ordered already by best-->worst
 design
 #what is the balance on this vector?
	res$obj_vals[1]
	#compute balance explicitly in R to double check
	compute_objective_val(X, design) #same as above
	#how far have we come?
	ged
	#we can cut it here
	stopSearch(ged)
	}
}
\author{
Adam Kapelner
}
