% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_ppd.R
\name{sample_ppd}
\alias{sample_ppd}
\title{Sample from the Posterior Predictive Distribution}
\usage{
sample_ppd(models, mod_id, s = 1000, nthreads = 8)
}
\arguments{
\item{models}{A \code{GHRmodels} object.}

\item{mod_id}{Character; model identifier (from \code{models$mod_gof$model_id}).}

\item{s}{An integer specifying the number of samples to draw from the posterior predictive distribution.}

\item{nthreads}{An integer specifying the number of threads for parallel computation to refit the model.
Default is \code{8}.}
}
\value{
A \code{data.frame} containing columns for each of the posterior
predictive samples and one column with observed data.
}
\description{
This function refits a specified model from a \code{GHRmodels} object and generates
samples from its posterior predictive distribution.
}
\examples{
\donttest{
# Load example dataset
data(dengueMS)

# Declare formulas
formulas <- c("dengue_cases ~ tmin +  f(year, model='rw1')")

# Tranform formulas into a 'GHRformulas' object
ghr_formula <- as_GHRformulas(formulas)

# Fit multiple models 
results <- fit_models(
  formulas = ghr_formula,
  data     = dengue_MS[dengue_MS$year \%in\% 2005:2010,],
  family   = "nbinomial",
  name     = "model",
  offset   = "population",
  nthreads = 2,
  control_compute = list(config = FALSE),
  pb       = TRUE
)

# Generate 100 samples from the posterior predictive distribution of the model
ppd_df <- sample_ppd( 
  results,
  mod_id = "model1", 
  s = 100,
  nthreads = 2)
}

}
