% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.netsim}
\alias{summary.netsim}
\title{Summary Model Statistics}
\usage{
\method{summary}{netsim}(object, at, digits = 3, ...)
}
\arguments{
\item{object}{An \code{EpiModel} object of class \code{netsim}.}

\item{at}{Time step for model statistics.}

\item{digits}{Number of significant digits to print.}

\item{...}{Additional summary function arguments.}
}
\description{
Extracts and prints model statistics simulated with \code{netsim}.
}
\details{
Summary statistics for the main epidemiological outcomes (state and transition
size and prevalence) from an \code{netsim} model. Time-specific summary
measures are provided, so it is necessary to input a time of interest.
}
\examples{
\dontrun{
## Independent SI Model
# Initialize network and set network model parameters
nw <- network.initialize(n = 100, bipartite = 50, directed = FALSE)
formation <- ~ edges
target.stats <- 50
dissolution <- ~ offset(edges)
duration <- 20
coef.diss <- dissolution_coefs(dissolution, duration)

# Estimate the ERGM models (see help for netest)
# Skipping model diagnostics for this, but one should always run these
est1 <- netest(nw,
               formation,
               dissolution,
               target.stats,
               coef.diss,
               verbose = FALSE)

# Parameters, initial conditions, and controls for model
param <- param.net(inf.prob = 0.3,
                   inf.prob.m2 = 0.15)
init <- init.net(i.num = 10, i.num.m2 = 10)
control <- control.net(type = "SI", nsteps = 100,
                       nsims = 5, verbose.int = 0)

# Run the model simulation
mod <- netsim(est1, param, init, control)

summary(mod, at = 1)
summary(mod, at = 50)
summary(mod, at = 100)
}
}
\seealso{
\code{\link{netsim}}
}
\keyword{extract}

