% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.netsim}
\alias{plot.netsim}
\title{Plot Data from a Stochastic Network Epidemic Model}
\usage{
\method{plot}{netsim}(x, type = "sim", sim, at = 1, col.status = FALSE,
  shp.bip = NULL, zeromarg = TRUE, stats, sim.lwd, sim.col, sim.lty = 1,
  targ.col, targ.lwd = 2, targ.lty = 2, plots.joined, plot.leg = TRUE,
  ...)
}
\arguments{
\item{x}{an \code{EpiModel} model object of class \code{netsim}.}

\item{type}{type of plot: \code{"sim"} for epidemic model results,
\code{"network"} for a static network plot (\code{plot.network}),
or \code{"formation"} for network formation statistics.}

\item{sim}{if \code{type="network"}, simulation number for network graph.}

\item{at}{if \code{type="network"}, time step for network graph.}

\item{col.status}{if \code{TRUE} and \code{type="network"}, automatic disease
status colors (blue = susceptible, red = infected, , green = recovered).}

\item{shp.bip}{if \code{type="network"} and a bipartite simulation, shapes
for the mode 2 vertices, with acceptable inputs of "triangle" and
"square". Mode 1 vertices will be circles.}

\item{zeromarg}{if \code{TRUE} and \code{type="network"}, automatically
sets plot margins to 0 on all sides.}

\item{stats}{if \code{type="formation"}, network statistics to plot, among
those specified in \code{nwstats.formula} of \code{\link{control.net}},
with the default to plot all statistics.}

\item{sim.col}{a vector of standard R colors to be used for individual
simulation lines, with default colors based on \code{RColorBrewer}
color palettes.}

\item{sim.lwd}{line width for individual simulation lines, with defaults based
on number of simulations (more simulations equals thinner lines).}

\item{sim.lty}{line type for the individual simulation lines.}

\item{targ.col}{vector of standard R colors for target statistic lines, with
default colors based on \code{RColorBrewer} color palettes.}

\item{targ.lwd}{line width for the line showing the target statistic values.}

\item{targ.lty}{line type for the line showing the target statistic values.}

\item{plots.joined}{if \code{TRUE} and \code{type="formation"}, combine all
target statistics in one plot, versus one plot per target statistic if
\code{FALSE}.}

\item{plot.leg}{if \code{TRUE}, show legend (only if \code{plots.joined=TRUE}).}

\item{...}{additional arguments to pass.}
}
\description{
Plots epidemiological and network data from a stochastic network
             model simulated with \code{netsim}.
}
\details{
This plot function can produce three types of plots with a stochastic network
model simulated through \code{\link{netsim}}:
\enumerate{
 \item \strong{\code{type="sim"}}: epidemic model results (e.g., disease
       prevalence and incidence) may be plotted. In this case, this plotting
       function wraps the \code{\link{plot.icm}} function, as the stochastic
       epidemiological results are in the same data structure. Consult the
       help page for \code{plot.icm} for all the plotting parameters.
 \item \strong{\code{type="network"}}: a static network plot will be generated.
       A static network plot of a dynamic network is a cross-sectional
       extraction of that dynamic network at a specific time point. This
       plotting function wraps the \code{\link{plot.network}} function in the
       \code{network} package. Consult the help page for \code{plot.network}
       for all the plotting parameters. In addition, five plotting parameters
       specific to \code{netsim} plots are available: \code{sim}, \code{at},
       \code{col.status}, \code{shp.bip}, and \code{zeromarg}.
 \item \strong{\code{type="formation"}}: summary network statistics related to
       the network model formation are plotted. These plots are similar to the
       formation plots for \code{netdx} objects. When running a \code{netsim}
       simulation, one must specify there that \code{save.nwstats=TRUE}; the
       plot here will then show the network statistics requested explicitly in
       \code{nwstats.formula}, or will use the formation formula set in
       \code{netest} otherwise.
}
}
\examples{
\dontrun{
## Independent SI Model
# Initialize network and set network model parameters
nw <- network.initialize(n = 100, bipartite = 50, directed = FALSE)
formation <- ~ edges
target.stats <- 50
dissolution <- ~ offset(edges)
duration <- 20
coef.diss <- dissolution_coefs(dissolution, duration)

# Estimate the network model
est <- netest(nw,
              formation,
              dissolution,
              target.stats,
              coef.diss,
              verbose = FALSE)

# Simulate the epidemic model
param <- param.net(trans.rate = 0.3, trans.rate.m2 = 0.15)
init <- init.net(i.num = 10, i.num.m2 = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5,
                       verbose = FALSE, save.nwstats = TRUE,
                       nwstats.formula = ~ edges + meandeg + concurrent)
mod <- netsim(est, param, init, control)

# Plot epidemic trajectory (default type)
plot(mod, type = "sim")
plot(mod, type = "sim", popfrac = FALSE)
plot(mod, type = "sim", y = "si.flow")

# Plot static networks
plot(mod, type = "network")

# Automatic coloring of infected nodes as red
plot(mod, type = "network",
     col.status = TRUE, at = 50)
plot(mod, type = "network",
     col.status = TRUE, at = 50, sim = 5)

# Automatic shape by mode number (circle = mode 1)
plot(mod, type = "network", at = 50,
     col.status = TRUE, shp.bip = "square")
plot(mod, type = "network", at = 50,
     col.status = TRUE, shp.bip = "triangle")

# Remove the automatic zero margin to include a title
plot(mod, type = "network", zeromarg = FALSE,
     main = "My Network Plot")

# Plot formation statistics
plot(mod, type = "formation")
plot(mod, type = "formation", plots.joined = FALSE)
plot(mod, type = "formation", sim = 2:4)
plot(mod, type = "formation", plots.joined = FALSE,
     stats = c("edges", "concurrent"))
plot(mod, type = "formation", stats = "meandeg",
     sim.lwd = 2, sim.col = "seagreen")
}
}
\seealso{
\code{\link{plot.icm}}, \code{\link{plot.network}}
}
\keyword{plot}

