% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_grid.R
\name{generate_grid}
\alias{generate_grid}
\title{Generate a grid around the input point}
\usage{
generate_grid(lon, lat, squareSize = 10, stepSize = 0.0025)
}
\arguments{
\item{lon}{Longitude of the grid center (in degrees; WGS 84). One value, data type "numeric" and finite.}

\item{lat}{Latitude of the grid center (in degrees; WGS 84). One value, data type "numeric" and finite.}

\item{squareSize}{Square size (in km). One value, data type "numeric" and finite.}

\item{stepSize}{Step size for the square sampling (in degree). One value, data type "numeric" and finite.}
}
\value{
A list containing a data frame with longitude and latitude of the grid and a vector containing the length of the longitudinal and latitudinal sequence.
}
\description{
Generate a grid around a longitude and latitude, with a defined square size and step size.
}
\examples{
#Generate a 10x10 km grid with a step size of 0.0025 degrees
temp <- generate_grid(lon = 8.728898, lat = 46.93756, squareSize = 10, stepSize = 0.0025)

#Part of the generated coordinates
temp$df[105:115,]
}
\author{
Livio Bätscher, Jurriaan M. de Vos
}
