% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdc.R
\name{mdc}
\alias{mdc}
\title{Martingale Difference Correlation}
\usage{
mdc(X, Y, center = "U")
}
\arguments{
\item{X}{A vector, matrix or data frame, where rows represent samples, and columns represent variables.}

\item{Y}{A vector, matrix or data frame, where rows represent samples, and columns represent variables.}

\item{center}{The approach for centering, including
\itemize{
  \item \code{U}: U-centering which leads to an unbiased estimator;
  \item \code{D}: double-centering which leads to a biased estimator. 
}}
}
\value{
\code{mdc} returns the value of squared martingale difference correlation.
}
\description{
\code{mdc} measures conditional mean dependence of \code{Y} given \code{X},
where each contains one variable (univariate) or more variables (multivariate).
}
\examples{
# X, Y are 10 x 2 matrices with 10 samples and 2 variables
X <- matrix(rnorm(10 * 2), 10, 2)
Y <- matrix(rnorm(10 * 2), 10, 2)

mdc(X, Y, center = "U")
mdc(X, Y, center = "D")
}
\references{
Shao, X., and Zhang, J. (2014).
  Martingale difference correlation and its use in high-dimensional variable screening.
  Journal of the American Statistical Association, 109(507), 1302-1318.
  \url{http://dx.doi.org/10.1080/01621459.2014.887012}.

Park, T., Shao, X., and Yao, S. (2015).
  Partial martingale difference correlation.
  Electronic Journal of Statistics, 9(1), 1492-1517.
  \url{http://dx.doi.org/10.1214/15-EJS1047}.
}
