% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulDiagnosis.R
\name{simulDiagnosis}
\alias{simulDiagnosis}
\title{Simulation Diagnostics}
\usage{
simulDiagnosis(data_Hat, data_True, sgn = FALSE)
}
\arguments{
\item{data_Hat}{List containing the estimated high-frequency data, with components \code{y_Est} (estimated response vector) and \code{beta_Est} (estimated coefficient vector).}

\item{data_True}{List containing the true high-frequency data, with components \code{y_Gen} (true response vector) and \code{Beta_Gen} (true coefficient vector).}

\item{sgn}{Logical value indicating whether to compute the sign recovery percentage. Default is \code{FALSE}.}
}
\value{
If \code{sgn} is \code{FALSE}, the function returns the Mean Squared Error (MSE) between the true and estimated response vectors. If \code{sgn} is \code{TRUE}, the function returns a list containing both the MSE and the sign recovery percentage.
}
\description{
This function provides diagnostics for evaluating the accuracy of simulated data. Specifically, it computes the Mean Squared Error (MSE) between the true and estimated response vectors, and optionally, the sign recovery percentage of the coefficient vector.
}
\details{
The function takes in the generated high-frequency data (\code{data_True}) and the estimated high-frequency data (\code{data_Hat}), and returns the Mean Squared Error (MSE) between the true and estimated values of the response vector. If the \code{sgn} parameter is set to \code{TRUE}, the function additionally computes the percentage of correctly recovered signs of the coefficient vector.
}
\examples{
true_data <- list(y_Gen = c(1, 2, 3), Beta_Gen = c(1, -1, 0))
est_data <- list(y_Est = c(1.1, 1.9, 2.8), beta_Est = c(1, 1, 0))
mse <- simulDiagnosis(est_data, true_data)
results <- simulDiagnosis(est_data, true_data, sgn = TRUE)

}
\keyword{MSE}
\keyword{diagnostics}
\keyword{recovery}
\keyword{sign}
\keyword{simulation}
