% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chowlin.R
\name{chowlin}
\alias{chowlin}
\title{Function to perform Chow-Lin temporal disaggregation from \insertCite{chow1971best;textual}{DisaggregateTS}
and its special case counterpart, Litterman \insertCite{litterman1983random;textual}{DisaggregateTS}.}
\usage{
chowlin(Y, X, rho, aggMat = "sum", aggRatio = 4, litterman = FALSE)
}
\arguments{
\item{Y}{The low-frequency response series (a \eqn{n_l \times 1} matrix).}

\item{X}{The high-frequency indicator series (a \eqn{n \times p} matrix).}

\item{rho}{The AR(1) residual parameter. Must be strictly between \eqn{-1} and \eqn{1}.}

\item{aggMat}{Aggregation matrix method: 'first', 'sum', 'average', 'last'. Default is 'sum'.}

\item{aggRatio}{Aggregation ratio, e.g. 4 for annual-to-quarterly, 3 for quarterly-to-monthly. Default is 4.}

\item{litterman}{Boolean. If TRUE, use Litterman variance-covariance method, otherwise use Chow-Lin. Default is FALSE.}
}
\value{
A list containing the following elements:
\itemize{
\item \code{y}: Estimated high-frequency response series (an \eqn{n \times 1} matrix).
\item \code{betaHat}: Estimated coefficient vector (a \eqn{p \times 1} matrix).
\item \code{u_l}: Estimated aggregate residual series (an \eqn{n_l \times 1} matrix).
}
}
\description{
Used in \code{\link{disaggregate}} to find estimates given the optimal \eqn{rho} parameter.
}
\references{
\insertAllCited{}
}
\keyword{internal}
