% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/farringtonManning.R
\name{farrington.manning}
\alias{farrington.manning}
\title{Farrington-Manning test for rate difference}
\usage{
farrington.manning(
  group1,
  group2,
  delta = 0,
  alternative = "greater",
  alpha = 0.025
)
}
\arguments{
\item{group1}{a logical vector of data from group 1, where \code{TRUE} indicates a success}

\item{group2}{a logical vector of data from group 2, where \code{TRUE} indicates a success}

\item{delta}{the rate difference under the null hypothesis}

\item{alternative}{character string indicating the alternative to use, either of
"two.sided", "less", "greater"}

\item{alpha}{the significance level (acceptable error of the first kind),
a two-sided confidence intnerval is returned with confidence level 1 - 2*alpha, such that
the lower bound is a valid one sided confidence interval at the confidence level 1 - alpha.}
}
\value{
A list of class "htest" containing the following components:
\tabular{ll}{
 \code{statistic}:\tab the value of the Z-statistic\cr
 \code{parameter}:\tab delta, rate difference (group 1 - group 2) under the null hypothesis\cr
 \code{p.value}:\tab the p-value for the Farrington-Manning test\cr
 \code{null.value}:\tab rate difference (group 1 - group 2) under the null\cr
 \code{alternative}:\tab a character string indicating the alternative hypothesis\cr
 \code{method}:\tab a character string indicating the exact method employed\cr
 \code{data.name}:\tab a character string giving the names of the data used\cr
 \code{estimate}:\tab the estimated rate difference (maximum likelihood)\cr
 \code{conf.int}:\tab a confidence interval for the rate difference\cr
 \code{sample.size}:\tab the total sample size used for the test\cr
}
}
\description{
The Farrington-Manning test for rate differences can be used to
 compare the rate difference of successes between two groups to a preset value.
 It uses an explicit formula for the standard deviation of the test statistic under
 the null hypothesis [1].
}
\details{
The Farrington-Maning test for rate differences test the null hypothesis
 of \deqn{H_{0}: p_{1} - p_{2} = \delta}{H[0]: p[1] - p[2] = \delta} for the "two.sided" alternative
 (or \eqn{\geq}{\ge} for the "greater" respectively \eqn{\leq}{\le} for the "less" alternative).
 This formulation allows to specify non-inferiority and superiority
 test in a consistent manner:
 \describe{
     \item{non-inferiority}{for delta < 0 and alternative == "greater" the null hypothesis
     reads \eqn{H_{0}: p_{1} - p_{2} \geq \delta}{H[0]: p[1] - p[2] \ge \delta} and
     consequently rejection allows concluding that \eqn{p_1 \geq p_2 + \delta}{p[1] \ge p[2] + \delta}
     i.e. that the rate of success in group one is at least the
     success rate in group two plus delta - as delta is negagtive this is equivalent to the success rate of group 1
     being at worst |delta| smaller than that of group 2.}
     \item{superiority}{for delta >= 0 and alternative == "greater" the null hypothesis
     reads \eqn{H_{0}: p_{1} - p_{2} \geq \delta}{H[0]: p[1] - p[2] \ge \delta} and
     consequently rejection allows concluding that \eqn{p_1 \geq p_2 + \delta}{p[1] \ge p[2] + \delta}
     i.e. that the rate of success in group one is at least delta greater than the
     success rate in group two.}
}
The confidence interval is always computed as two-sided, but with 1-2\eqn{\alpha} confidence level
in case of a one-sided hypthesis. This means that the lower or upper vound are valid one-sided
confidence bounds at level \eqn{\alpha} in this case.
The confidence interval is constructed by inverting the two-sided test directly.
}
\examples{
x <- c(rep(TRUE, 20), rep(FALSE, 15))
y <- c(rep(TRUE, 30), rep(FALSE, 25))

farrington.manning(x, y, -.3)

}
\references{
[1] Farrington, Conor P., and Godfrey Manning. "Test statistics and sample size formulae for comparative binomial trials with null hypothesis of non-zero risk difference or non-unity relative risk." Statistics in medicine 9.12 (1990): 1447-1454.
}
\author{
Kevin Kunzmann
}
\keyword{Farrington-Manning}
\keyword{rates}
\keyword{test}
