% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth.R
\name{depthMah}
\alias{depthMah}
\title{Mahalanobis Depth}
\usage{
depthMah(u, X, cov = NULL, mean = NULL, threads = -1)
}
\arguments{
\item{u}{Numerical vector or matrix whose depth is to be calculated. Dimension has to be the same as that of the observations.}

\item{X}{The data as a matrix, data frame or list. If it is a matrix or data frame, then each row is viewed as one multivariate observation. If it is a list, all components must be numerical vectors of equal length (coordinates of observations).}

\item{cov}{custom covariance matrix passed. If NULL standard calculations will be based on standard covariance estimator.}

\item{mean}{custom mean vector. If null --- mean average will be used.}

\item{threads}{number of threads used in parallel computations. Default value -1 means that all possible cores will be used.}
}
\description{
Computes the mahalanobis depth of a point or vectors of points with respect to a multivariate data set.
}
\details{
Calculation of Mahalanobis depth is exact.

Returns the depth of multivariate point \code{u} with respect to data set \code{X}.
}
\examples{
x <- matrix(rnorm(9999), nc = 3)
depthMah(x, x)

}
\author{
Daniel Kosiorowski, Mateusz Bocian, Anna Wegrzynkiewicz and Zygmunt Zawadzki from Cracow University of Economics.
}
\keyword{depth}
\keyword{function}
\keyword{multivariate}
\keyword{nonparametric}
