% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DemographicTable.R
\name{DemographicTable}
\alias{DemographicTable}
\title{Create Demographic Table}
\usage{
DemographicTable(
  data,
  data.name = substitute(data),
  groups = NULL,
  keep_missing_group = TRUE,
  avoid,
  avoid_pattern,
  select,
  select_pattern,
  overall = TRUE,
  ...
)
}
\arguments{
\item{data}{a \code{\link[base]{data.frame}}}

\item{data.name}{\code{\link[base]{character}} scalar, or the argument call of \code{data}.
A user-friendly name of the input \code{data}.}

\item{groups}{\code{\link[base]{character}} scalar or vector, the name(s) of group(s) between which the comparisons are to be made.
Default \code{NULL} indicating no comparison between group.}

\item{keep_missing_group}{\code{\link[base]{logical}} scalar, whether to keep the subjects with missing \code{group}
in a separate group (coded \code{group = '.missing'})}

\item{avoid}{\code{\link[base]{character}} vector, the name{s} of variable{s} to be avoided.}

\item{avoid_pattern}{\code{\link[base]{character}} scalar as regular expression \code{\link[base]{regex}}, 
the pattern of the names of the variable(s) to be avoided}

\item{select}{\code{\link[base]{character}} vector, the name(s) of variable(s) to be included.}

\item{select_pattern}{\code{\link[base]{character}} scalar as regular expression \code{\link[base]{regex}}, 
the pattern of the names of the variable(s) to be included.}

\item{overall}{\code{\link[base]{logical}} scalar, whether a column of overall summary statistics should be provided.
Default \code{TRUE}.}

\item{...}{potential parameters}
}
\value{
\code{\link{DemographicTable}} returns an object of S3 class \code{'DemographicTable'}, 
which inherits from \code{\link[base]{matrix}}.
}
\description{
Create a demographic table with simple summary statistics, with optional comparison(s) over one or more groups.
}
\details{
A demographic table with simple summary statistics, with optional comparison(s) over one or more groups, is created.

\code{\link[base]{numeric}} variables are summarized in means, standard deviations, medians, inter-quartile-ranges (IQR), 
skewness, Shapiro-Wilk normality test and ranges.
If \code{group} is specified, they are compared using two-sample t-test \code{\link[stats]{t.test}}, 
Wilcoxon test \code{\link[stats]{wilcox.test}}, ANOVA \code{\link[stats]{aov}} and/or 
Kruskal-Wallis test \code{\link[stats]{kruskal.test}}.

\code{\link[base]{logical}} and \code{\link[base]{factor}} variables are summarized in counts and percentages.
If \code{group} is specified, they are compared using chi-squared test \code{\link[stats]{prop.test}} 
and/or Fisher's exact test \code{\link[stats]{fisher.test}}.
}
\examples{
DemographicTable(esoph)
DemographicTable(ToothGrowth, groups = 'supp')
DemographicTable(warpbreaks, groups = c('wool', 'tension'))

# write to Word file
library(flextable)
library(officer)
x = read_docx() |> body_add_flextable(value = as_flextable(DemographicTable(esoph)))
(out = file.path(tempdir(), 'demostable.docx'))
print(x, target = out)
# system(paste('open', out)) # works on Mac & Windows, but requires Microsoft Word
file.remove(out)

}
