% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefnames.R
\name{renewalCoef}
\alias{renewalCoef}
\title{Get named vector of coefficients for renewal objects}
\usage{
renewalCoef(object, ...)
}
\arguments{
\item{object}{an object, there are methods for several classes, see Details.}

\item{...}{further arguments to be passed to \code{renewalNames}, usually
something like \code{target = "weibull"}.}
}
\description{
Get named vector of coefficients for renewal objects.
}
\details{
This is a convenience function for constructing named vector of coefficients
for renewal count models. Such vectors are needed, for example, for starting
values in the model fitting procedures. The simplest way to get a suitably
named vector is to take the coefficients of a fitted model but if the fitting
procedure requires initial values, this is seemingly a circular situation.

The overall idea is to take coefficients specified by \code{object} and
transform them to coefficients suitable for a renewal count model as
specified by the arguments \code{"..."}. The provided methods eliminate the
need for tedius manual preparation of such vectors and in the most common
cases allow the user to do this in a single line.

The default method extracts the coefficients of \code{object} using

\code{co <- coef(object)} (an error is raised if this fails). It prepares a
named numeric vector with names requested by the arguments in \code{"..."}
and assigns \code{co} to the first \code{length(co)} elements of the prepared
vector. The net effect is that the coefficients of a model can be initialised
from the coefficients of a nested model. For example a Poisson regression
model can be used to initialise a Weibull count model. Of course the non-zero
shape parameter(s) of the Weibull model need to be set separately.

If \code{object} is from class \code{glm}, the method is identical to the
default method.

If object is from class \code{\link{renewalCoefList}}, its elements are
simply concatenated in one long vector.
}
\references{
\insertRef{CountrJssArticle}{Countr}
}
\seealso{
\code{\link{renewalNames}}
}
