% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_creator.R
\name{prob.creator}
\alias{prob.creator}
\title{Probability Matrix Creator.}
\usage{
prob.creator(
  num.factors,
  num.factor.levels,
  likelihood.encountering,
  print.result = FALSE
)
}
\arguments{
\item{num.factors}{Number of factors in the model (e.g., factor \eqn{\alpha_i} with
levels i=1,2 is 1 factor). Input for \code{num.factors} should be a single number.}

\item{num.factor.levels}{Number of levels for each factor (e.g., factor \eqn{\alpha_i}
with i=1,2 has 2 levels). Input for \code{num.factor.levels} may be a vector, a matrix, or a dataframe.}

\item{likelihood.encountering}{The probability of seeing each level of each factor (e.g., if the factor levels for
\eqn{\alpha_i} are equally likely, then the probabilities would be c(1/2, 1/2)).
The probabilities for each factor should sum to one. Input for \code{likelihood.encountering} may be a vector, a matrix,
or a dataframe.}

\item{print.result}{Displays final probability matrix.}
}
\value{
Returns a matrix with two columns, one with the factor number and the other with the likelihoods of encountering.
}
\description{
\code{prob.creator} creates a matrix of probabilities of encountering factor levels to support
construction of input for \code{gibbs.sampler}, which uses the Bayesian Mission Mean approach to analysis.
}
\details{
The ANOVA model includes main effects and two-way interactions. Priors
on model parameters are assumed to be independent of each other; beta is
then defined as the set of model parameters, which is multivariate normal.
}
