% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{signature_plot}
\alias{signature_plot}
\title{CpG signature plot}
\usage{
signature_plot(
  cpg_obj,
  data,
  meta_data,
  sample_id_column,
  true_label_column,
  color_dict = NULL,
  color_others = "black",
  as_panel = TRUE,
  is_beta = TRUE,
  base_size = 14,
  ...
)
}
\arguments{
\item{cpg_obj}{A CimpleG object, as generated by the CimpleG function. Alternatively a names character vector or list with the signatures.}

\item{data}{Matrix or data.frame that should have the samples and signatures to plot.
Samples should be in rows and probes/CpGs in columns.}

\item{meta_data}{Data.frame containing metadata from samples in `data`.}

\item{sample_id_column}{Name of the column containing the sample id in the meta_data data.frame}

\item{true_label_column}{Name of the column containing the true labels of the samples in the meta_data data.frame}

\item{color_dict}{Named string featuring colors as values and labels (true labels) as names}

\item{color_others}{The name or hex code of a color by which the non-target samples should be colored by.}

\item{as_panel}{A boolean, if TRUE (default) a single figure panel with all the signatures will be generated.
Otherwise, the individual plots will be returned as a list.}

\item{is_beta}{A boolean, if TRUE (default) the values will be plotted in a scale suitable for Beta values.
Otherwise, the values will be plotted in scale suitable for M values.}

\item{base_size}{An integer defining the base size of the text in the plot. Default is `14`.}

\item{...}{Parameters passed to the ggplot2::theme function.}
}
\value{
A list with the data and the ggplot2 plot object.
}
\description{
CpG signature plot
}
