% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{kronecker,Expression,ANY-method}
\alias{kronecker,Expression,ANY-method}
\alias{kronecker}
\alias{\%x\%}
\alias{kronecker,ANY,Expression-method}
\title{Kronecker Product}
\usage{
\S4method{kronecker}{Expression,ANY}(X, Y, FUN = "*", make.dimnames = FALSE, ...)

\S4method{kronecker}{ANY,Expression}(X, Y, FUN = "*", make.dimnames = FALSE, ...)
}
\arguments{
\item{X}{An \linkS4class{Expression} or matrix.}

\item{Y}{An \linkS4class{Expression} or matrix.}

\item{FUN}{Hardwired to "*" for the kronecker product.}

\item{make.dimnames}{(Unimplemented) Dimension names are not supported in \linkS4class{Expression} objects.}

\item{...}{(Unimplemented) Optional arguments.}
}
\value{
An \linkS4class{Expression} that represents the kronecker product.
}
\description{
The generalized kronecker product of two matrices.
}
\examples{
X <- cbind(c(1,2), c(3,4))
Y <- Variable(2,2)
val <- cbind(c(5,6), c(7,8))

obj <- X \%x\% Y
prob <- Problem(Minimize(kronecker(X,Y)[1,1]), list(Y == val))
result <- solve(prob)
result$value
result$getValue(kronecker(X,Y))
}
