% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{eye_minus_inv}
\alias{eye_minus_inv}
\title{Unity Resolvent}
\usage{
eye_minus_inv(X)
}
\arguments{
\item{X}{An \linkS4class{Expression} or positive square matrix.}
}
\value{
An \linkS4class{Expression} representing the unity resolvent of the input.
}
\description{
The unity resolvent of a positive matrix. For an elementwise positive matrix \eqn{X}, this atom represents \eqn{(I - X)^{-1}},
and it enforces the constraint that the spectral radius of \eqn{X} is at most 1.
}
\details{
This atom is log-log convex.
}
\examples{
A <- Variable(2,2, pos = TRUE)
prob <- Problem(Minimize(matrix_trace(A)), list(eye_minus_inv(A) <=1))
result <- solve(prob, gp = TRUE)
result$value
result$getValue(A)
}
