% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbabilityFunctions.R
\name{pkolmogorov}
\alias{pkolmogorov}
\title{Kolmogorov CDF}
\usage{
pkolmogorov(q, summands = ceiling(q * sqrt(72) + 3/2))
}
\arguments{
\item{q}{Quantile input to CDF}

\item{summands}{Number of summands for infinite sum (the default should have
machine accuracy)}
}
\value{
If \eqn{Z} is the random variable following the Kolmogorov
        distribution, the quantity \eqn{P(Z \leq q)}
}
\description{
CDF of the Kolmogorov distribution.
}
\examples{
CPAT:::pkolmogorov(0.1)
}
