% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_interface_predict_clvfittedspending.R
\name{predict.clv.fitted.spending}
\alias{predict.clv.fitted.spending}
\alias{predict,clv.fitted.spending-method}
\title{Infer customers' spending}
\usage{
\method{predict}{clv.fitted.spending}(
  object,
  newdata = NULL,
  uncertainty = c("none", "boots"),
  level = 0.9,
  num.boots = 100,
  verbose = TRUE,
  ...
)

\S4method{predict}{clv.fitted.spending}(
  object,
  newdata = NULL,
  uncertainty = c("none", "boots"),
  level = 0.9,
  num.boots = 100,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted spending model for which prediction is desired.}

\item{newdata}{A \code{clv.data} object or data for the new customer prediction (see \link[CLVTools:newcustomer]{newcustomer.spending}).
If none or NULL is given, predictions are made for the data on which the model was fit.}

\item{uncertainty}{Method to produce confidence intervals of the predictions (parameter uncertainty). Either "none" (default) or "boots".}

\item{level}{Required confidence level, if \code{uncertainty="boots"}.}

\item{num.boots}{Number of bootstrap repetitions, if \code{uncertainty="boots"}. A low number may not produce intervals for all customers if they are not sampled.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Ignored}
}
\value{
An object of class \code{data.table} with columns:
\item{Id}{The respective customer identifier}
\item{actual.mean.spending}{Actual mean spending per transaction in the holdout period. Only if there is a holdout period otherwise it is not reported.}
\item{predicted.mean.spending}{The mean spending per transaction as predicted by the fitted spending model.}

If predicting for new customers (using \code{newcustomer.spending()}), a numeric scalar
indicating the expected spending is returned instead.
}
\description{
Infer customer's mean spending per transaction and compare it to the actual mean spending in the holdout period.

\subsection{New customer prediction}{
The fitted model can also be used to estimate the spending that a single, (fictional), average
newly alive customer is expected to make at the moment of the first transaction.
This is, for a customer which has no existing order history and that just "came alive".

The data on which the model was fit and which is stored in it is NOT used for this prediction.
See examples and \link[CLVTools:newcustomer]{newcustomer.spending} for more details.
}
}
\details{
If \code{newdata} is provided, the individual customer statistics underlying the model are calculated
the same way as when the model was fit initially. Hence, if \code{remove.first.transaction} was \code{TRUE},
this will be applied to \code{newdata} as well.

To predict for new customers, the output of \link[CLVTools:newcustomer]{newcustomer.spending} has to be given to \code{newdata}. See examples.
}
\section{Uncertainty Estimates}{

Bootstrapping is used to provide confidence intervals of all predicted metrics.
These provide an estimate of parameter uncertainty.
To create bootstrapped data, customer ids are sampled with replacement until reaching original
length and all transactions of the sampled customers are used to create a new \code{clv.data} object.
A new model is fit on the bootstrapped data with the exact same specification as used when
fitting \code{object} (incl. start parameters and `optimx.args`) and it is then used to predict on this data.

It is highly recommended to fit the original model (\code{object}) with a robust optimization
method, such as Nelder-Mead (\code{optimx.args=list(method='Nelder-Mead')}).
This ensures that the model can also be fit on the bootstrapped data.

All prediction parameters, incl \code{prediction.end} and \code{continuous.discount.factor}, are forwarded
to the prediction on the bootstrapped data.
Per customer, the boundaries of the confidence intervals of each predicted metric are the
sample quantiles (\code{quantile(x, probs=c((1-level)/2, 1-(1-level)/2)}).

See \link{clv.bootstrapped.apply} to create a custom bootstrapping procedure.
}

\examples{
\donttest{
data("apparelTrans")

# Fit gg model on data
apparel.holdout <- clvdata(apparelTrans, time.unit="w",
                           estimation.split = 52, date.format = "ymd")
apparel.gg <- gg(apparel.holdout)

# Estimate customers' mean spending per transaction
predict(apparel.gg)

# Estimate the mean spending per transaction a single,
# fictional, average new customer is expected to make
# See ?newcustomer.spending() for more examples
predict(apparel.gg, newdata=newcustomer.spending())

}

}
\seealso{
models to predict spending: \link{gg}.

models to predict transactions: \link{pnbd}, \link{bgnbd}, \link{ggomnbd}.

\code{\link[CLVTools:predict.clv.fitted.transactions]{predict}} for transaction models

\code{\link[CLVTools:newcustomer]{newdata.spending}} to create data to predict for customers without order history
}
